/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PluginPackageFilter
implements ClassNameFilter {
    private final String[] packageList;

    public PluginPackageFilter(List<String> packageList) {
        Objects.requireNonNull(packageList, "packageList");
        this.packageList = packageList.toArray(new String[0]);
    }

    @Override
    public boolean accept(String className) {
        for (String packageName : this.packageList) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PluginPackageFilter{packageList=" + Arrays.toString(this.packageList) + '}';
    }
}

