/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.plugin.PluginException;
import com.navercorp.pinpoint.profiler.util.JarFileUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class PluginManifest {
    private final String pluginId;
    private final String pluginCompilerVersion;
    private final List<String> pluginPackages;

    public PluginManifest(String pluginId, String pluginCompilerVersion, List<String> pluginPackages) {
        this.pluginId = pluginId;
        this.pluginCompilerVersion = pluginCompilerVersion;
        this.pluginPackages = pluginPackages;
    }

    public static PluginManifest of(JarFile jarFile) {
        Objects.requireNonNull(jarFile, "jarFile");
        Manifest manifest = PluginManifest.getManifest(jarFile);
        Attributes mainAttributes = manifest.getMainAttributes();
        String pluginId = JarFileUtils.getValue(mainAttributes, "Pinpoint-Plugin-Id", null);
        String pluginCompilerVersion = JarFileUtils.getValue(mainAttributes, "Pinpoint-Plugin-Compiler-Version", null);
        String pluginPackages = JarFileUtils.getValue(mainAttributes, "Pinpoint-Plugin-Package", "com.navercorp.pinpoint.plugin");
        List pluginPackageList = StringUtils.tokenizeToStringList((String)pluginPackages, (String)",");
        return new PluginManifest(pluginId, pluginCompilerVersion, pluginPackageList);
    }

    private static Manifest getManifest(JarFile jarFile) {
        try {
            return jarFile.getManifest();
        }
        catch (IOException e) {
            throw new PluginException(jarFile.getName() + " Manifest error", e);
        }
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPluginCompilerVersion() {
        return this.pluginCompilerVersion;
    }

    public List<String> getPluginPackages() {
        return this.pluginPackages;
    }

    public String toString() {
        return "PluginManifest{pluginId='" + this.pluginId + '\'' + ", pluginCompilerVersion='" + this.pluginCompilerVersion + '\'' + ", pluginPackages=" + this.pluginPackages + '}';
    }
}

