/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginGlobalContext;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.CodeSourceUtils;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjectorFactory;
import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import com.navercorp.pinpoint.profiler.plugin.ClassNameFilterChain;
import com.navercorp.pinpoint.profiler.plugin.DefaultProfilerPluginGlobalContext;
import com.navercorp.pinpoint.profiler.plugin.JarPlugin;
import com.navercorp.pinpoint.profiler.plugin.PinpointProfilerPackageSkipFilter;
import com.navercorp.pinpoint.profiler.plugin.PluginConfig;
import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import com.navercorp.pinpoint.profiler.plugin.PluginPackageFilter;
import com.navercorp.pinpoint.profiler.plugin.PluginSetup;
import com.navercorp.pinpoint.profiler.plugin.PluginSetupResult;
import com.navercorp.pinpoint.profiler.plugin.PluginsSetupResult;
import com.navercorp.pinpoint.profiler.plugin.ProfilerPluginContextLoader;
import com.navercorp.pinpoint.profiler.plugin.config.PluginLoadingConfig;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultProfilerPluginContextLoader
implements ProfilerPluginContextLoader {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ClassNameFilter profilerPackageFilter = new PinpointProfilerPackageSkipFilter();
    private final ProfilerConfig profilerConfig;
    private final PluginLoadingConfig pluginLoadingConfig;
    private final ServiceType configuredApplicationType;
    private final ClassInjectorFactory classInjectorFactory;
    private final PluginSetup pluginSetup;
    private final List<PluginJar> pluginJars;

    public DefaultProfilerPluginContextLoader(ProfilerConfig profilerConfig, PluginLoadingConfig pluginLoadingConfig, ServiceType configuredApplicationType, ClassInjectorFactory classInjectorFactory, PluginSetup pluginSetup, List<PluginJar> pluginJars) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.pluginLoadingConfig = Objects.requireNonNull(pluginLoadingConfig, "pluginLoadingConfig");
        this.configuredApplicationType = Objects.requireNonNull(configuredApplicationType, "configuredApplicationType");
        this.classInjectorFactory = Objects.requireNonNull(classInjectorFactory, "classInjectorFactory");
        this.pluginSetup = Objects.requireNonNull(pluginSetup, "pluginSetup");
        this.pluginJars = Objects.requireNonNull(pluginJars, "pluginJars");
    }

    @Override
    public PluginsSetupResult load(List<ProfilerPlugin> profilerPlugins) {
        DefaultProfilerPluginGlobalContext globalContext = new DefaultProfilerPluginGlobalContext(this.profilerConfig, this.configuredApplicationType);
        PluginsSetupResult pluginsSetupResult = new PluginsSetupResult();
        JarPluginComponents jarPluginComponents = new JarPluginComponents(this.pluginJars);
        for (ProfilerPlugin profilerPlugin : profilerPlugins) {
            jarPluginComponents.addProfilerPlugin(profilerPlugin);
        }
        Collection<JarPlugin<ProfilerPlugin>> jarPlugins = jarPluginComponents.buildJarPlugins();
        for (JarPlugin jarPlugin : jarPlugins) {
            List<PluginSetupResult> setupResults = this.setupPlugin(globalContext, jarPlugin);
            pluginsSetupResult.addPluginSetupResults(setupResults);
        }
        ServiceType detectedApplicationType = globalContext.getApplicationType();
        pluginsSetupResult.setApplicationType(detectedApplicationType);
        return pluginsSetupResult;
    }

    private List<PluginSetupResult> setupPlugin(ProfilerPluginGlobalContext globalContext, JarPlugin<ProfilerPlugin> plugin) {
        List<String> pluginPackageList = plugin.getPackageList();
        ClassNameFilter pluginFilterChain = this.createPluginFilterChain(pluginPackageList);
        List<ProfilerPlugin> filterProfilerPlugin = this.filterProfilerPlugin(plugin.getInstanceList(), this.pluginLoadingConfig.getDisabledPlugins());
        ArrayList<PluginSetupResult> result = new ArrayList<PluginSetupResult>();
        for (ProfilerPlugin profilerPlugin : filterProfilerPlugin) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} Plugin {}:{}", profilerPlugin.getClass(), (Object)"Pinpoint-Plugin-Package", pluginPackageList);
                this.logger.info("Loading plugin:{} pluginPackage:{}", (Object)profilerPlugin.getClass().getName(), (Object)profilerPlugin);
            }
            PluginConfig pluginConfig = new PluginConfig(plugin, pluginFilterChain);
            ClassInjector classInjector = this.classInjectorFactory.newClassInjector(pluginConfig);
            PluginSetupResult setupResult = this.pluginSetup.setupPlugin(globalContext, profilerPlugin, classInjector);
            result.add(setupResult);
        }
        return result;
    }

    @Deprecated
    private List<ProfilerPlugin> filterProfilerPlugin(List<ProfilerPlugin> originalProfilerPlugin, List<String> disabled) {
        ArrayList<ProfilerPlugin> result = new ArrayList<ProfilerPlugin>();
        for (ProfilerPlugin profilerPlugin : originalProfilerPlugin) {
            if (disabled.contains(profilerPlugin.getClass().getName())) {
                this.logger.info("Skip disabled plugin: {}", (Object)profilerPlugin.getClass().getName());
                continue;
            }
            result.add(profilerPlugin);
        }
        return result;
    }

    private ClassNameFilter createPluginFilterChain(List<String> packageList) {
        PluginPackageFilter pluginPackageFilter = new PluginPackageFilter(packageList);
        List<ClassNameFilter> chain = Arrays.asList(this.profilerPackageFilter, pluginPackageFilter);
        ClassNameFilterChain filterChain = new ClassNameFilterChain(chain);
        return filterChain;
    }

    private static class JarPluginComponents {
        private final Logger logger = LogManager.getLogger(this.getClass());
        private final Map<String, JarPluginComponent> componentMap;

        private JarPluginComponents(List<PluginJar> pluginJars) {
            this.componentMap = new LinkedHashMap<String, JarPluginComponent>(pluginJars.size());
            for (PluginJar pluginJar : pluginJars) {
                String key = this.generateKey(pluginJar.getURL());
                this.componentMap.put(key, new JarPluginComponent(pluginJar));
            }
        }

        private String generateKey(URL url) {
            return url.toExternalForm();
        }

        public void addProfilerPlugin(ProfilerPlugin profilerPlugin) {
            URL profilerPluginUrl = CodeSourceUtils.getCodeLocation(profilerPlugin.getClass());
            if (profilerPluginUrl == null) {
                this.logger.warn("Unable to determine url for: {}", profilerPlugin.getClass());
                return;
            }
            String key = this.generateKey(profilerPluginUrl);
            JarPluginComponent jarPluginComponent = this.componentMap.get(key);
            if (jarPluginComponent == null) {
                this.logger.warn("Unexpected ProfilerPlugin: {}", profilerPlugin.getClass());
                return;
            }
            jarPluginComponent.addProfilerPlugin(profilerPlugin);
        }

        public Collection<JarPlugin<ProfilerPlugin>> buildJarPlugins() {
            ArrayList<JarPlugin<ProfilerPlugin>> jarPlugins = new ArrayList<JarPlugin<ProfilerPlugin>>(this.componentMap.size());
            for (JarPluginComponent component : this.componentMap.values()) {
                jarPlugins.add(component.toJarPlugin());
            }
            return jarPlugins;
        }

        private static class JarPluginComponent {
            private final PluginJar pluginJar;
            private final List<ProfilerPlugin> profilerPlugins;

            private JarPluginComponent(PluginJar pluginJar) {
                this.pluginJar = Objects.requireNonNull(pluginJar, "pluginJar");
                this.profilerPlugins = new ArrayList<ProfilerPlugin>();
            }

            private void addProfilerPlugin(ProfilerPlugin profilerPlugin) {
                if (profilerPlugin != null) {
                    this.profilerPlugins.add(profilerPlugin);
                }
            }

            private JarPlugin<ProfilerPlugin> toJarPlugin() {
                return new JarPlugin<ProfilerPlugin>(this.pluginJar, this.profilerPlugins, this.pluginJar.getPluginPackages());
            }
        }
    }
}

