/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.interceptor.scope;

import com.navercorp.pinpoint.bootstrap.interceptor.scope.AttachmentFactory;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;

public class DefaultInterceptorScopeInvocation
implements InterceptorScopeInvocation {
    private final String name;
    private Object attachment = null;
    private int depth = 0;
    private int skippedBoundary = 0;

    public DefaultInterceptorScopeInvocation(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean tryEnter(ExecutionPolicy point) {
        switch (point) {
            case ALWAYS: {
                ++this.depth;
                return true;
            }
            case BOUNDARY: {
                if (this.isActive()) {
                    ++this.skippedBoundary;
                    return false;
                }
                ++this.depth;
                return true;
            }
            case INTERNAL: {
                if (this.isActive()) {
                    ++this.depth;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected: " + point);
    }

    public boolean canLeave(ExecutionPolicy point) {
        switch (point) {
            case ALWAYS: {
                return true;
            }
            case BOUNDARY: {
                if (this.skippedBoundary == 0 && this.depth == 1) {
                    return true;
                }
                --this.skippedBoundary;
                return false;
            }
            case INTERNAL: {
                return this.depth > 1;
            }
        }
        throw new IllegalArgumentException("Unexpected: " + point);
    }

    public void leave(ExecutionPolicy point) {
        if (this.depth == 0) {
            throw new IllegalStateException();
        }
        switch (point) {
            case ALWAYS: {
                break;
            }
            case BOUNDARY: {
                if (this.skippedBoundary == 0 && this.depth == 1) break;
                throw new IllegalStateException("Cannot leave with BOUNDARY interceptor. depth: " + this.depth);
            }
            case INTERNAL: {
                if (this.depth > 1) break;
                throw new IllegalStateException("Cannot leave with INTERNAL interceptor. depth: " + this.depth);
            }
            default: {
                throw new IllegalArgumentException("Unexpected: " + point);
            }
        }
        if (--this.depth == 0) {
            this.attachment = null;
        }
    }

    public boolean isActive() {
        return this.depth > 0;
    }

    public Object setAttachment(Object attachment) {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
        Object old = this.attachment;
        this.attachment = attachment;
        return old;
    }

    public Object getOrCreateAttachment(AttachmentFactory factory) {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
        if (this.attachment == null) {
            this.attachment = factory.createAttachment();
        }
        return this.attachment;
    }

    public Object getAttachment() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
        return this.attachment;
    }

    public Object removeAttachment() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
        Object old = this.attachment;
        this.attachment = null;
        return old;
    }

    public String toString() {
        return "InterceptorScopeInvocation(" + this.name + ")[depth=" + this.depth + "]";
    }
}

