/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.navercorp.pinpoint.profiler.instrument.transformer.HierarchyCaches;
import java.util.concurrent.ExecutionException;

public class DefaultHierarchyCaches
implements HierarchyCaches {
    private static final int MAX = 64;
    private final LoadingCache<String, Hierarchy> caches;
    private final int cacheSize;
    private final int cacheEntrySize;

    public DefaultHierarchyCaches(int size, int entrySize) {
        if (size <= 0) {
            throw new IllegalArgumentException("negative cache size:" + size);
        }
        this.cacheSize = this.getCacheSize(size);
        this.cacheEntrySize = this.getCacheEntrySize(entrySize);
        this.caches = CacheBuilder.newBuilder().maximumSize((long)this.cacheSize).initialCapacity(this.cacheSize).concurrencyLevel(4).build((CacheLoader)new CacheLoader<String, Hierarchy>(){

            public Hierarchy load(String s) throws Exception {
                return new Hierarchy();
            }
        });
    }

    private int getCacheEntrySize(int entrySize) {
        if (entrySize <= 0) {
            return this.cacheSize;
        }
        if (entrySize > 64) {
            return 64;
        }
        return entrySize;
    }

    private int getCacheSize(int size) {
        if (size > 64) {
            return 64;
        }
        return size;
    }

    @Override
    public boolean get(String key, String classInternalName) {
        try {
            return ((Hierarchy)this.caches.get((Object)key)).cache.getIfPresent((Object)classInternalName) != null;
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    @Override
    public void put(String key, String classInternalName) {
        try {
            ((Hierarchy)this.caches.get((Object)key)).cache.put((Object)classInternalName, (Object)Boolean.TRUE);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("caches=").append(this.caches.asMap()).append(", ");
        sb.append("size=").append(this.caches.size()).append(", ");
        sb.append("stats=").append(this.caches.stats());
        sb.append("}");
        return sb.toString();
    }

    class Hierarchy {
        Cache<String, Boolean> cache;

        public Hierarchy() {
            this.cache = CacheBuilder.newBuilder().maximumSize((long)DefaultHierarchyCaches.this.cacheEntrySize).initialCapacity(DefaultHierarchyCaches.this.cacheEntrySize).concurrencyLevel(4).build();
        }

        public String toString() {
            return this.cache.asMap().keySet().toString();
        }
    }
}

