/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder.proxy;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestParser;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestParserLoaderService;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestParserProvider;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestParserProviderSetupContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultProxyRequestParserLoaderService
implements ProxyRequestParserLoaderService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final List<ProxyRequestParserProvider> providerList;
    private final List<ProxyRequestParser> proxyHttpHeaderParserList = new ArrayList<ProxyRequestParser>();

    public DefaultProxyRequestParserLoaderService(List<ProxyRequestParserProvider> providerList, ProfilerConfig profilerConfig) {
        this.providerList = Objects.requireNonNull(providerList, "providerList");
        this.load(profilerConfig);
    }

    private void load(final ProfilerConfig profilerConfig) {
        this.logger.info("Loading ProxyRequestParserProvider");
        for (ProxyRequestParserProvider provider : this.providerList) {
            ProxyRequestParserProviderSetupContext context = new ProxyRequestParserProviderSetupContext(){

                @Override
                public void addProxyRequestParser(ProxyRequestParser parser) {
                    if (parser != null) {
                        DefaultProxyRequestParserLoaderService.this.logger.info("Add ProxyRequestParser={}", (Object)parser);
                        parser.init(profilerConfig);
                        DefaultProxyRequestParserLoaderService.this.proxyHttpHeaderParserList.add(parser);
                    }
                }
            };
            provider.setup(context);
        }
    }

    @Override
    public List<ProxyRequestParser> getProxyRequestParserList() {
        return this.proxyHttpHeaderParserList;
    }
}

