/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.module.DefaultClientFactory;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.TcpDataSender;
import com.navercorp.pinpoint.profiler.sender.ThriftMessageSerializer;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.TBaseSerializer;
import java.util.Objects;
import org.apache.thrift.TBase;

public class TcpDataSenderProvider
implements Provider<EnhancedDataSender<MetaDataType>> {
    private final ThriftTransportConfig thriftTransportConfig;
    private final Provider<PinpointClientFactory> clientFactoryProvider;
    private final Provider<HeaderTBaseSerializer> tBaseSerializerProvider;
    private final MessageConverter<MetaDataType, TBase<?, ?>> messageConverter;

    @Inject
    public TcpDataSenderProvider(ThriftTransportConfig thriftTransportConfig, @DefaultClientFactory Provider<PinpointClientFactory> clientFactoryProvider, Provider<HeaderTBaseSerializer> tBaseSerializerProvider, @MetadataDataSender MessageConverter<MetaDataType, TBase<?, ?>> messageConverter) {
        this.thriftTransportConfig = Objects.requireNonNull(thriftTransportConfig, "thriftTransportConfig");
        this.clientFactoryProvider = Objects.requireNonNull(clientFactoryProvider, "clientFactoryProvider");
        this.tBaseSerializerProvider = Objects.requireNonNull(tBaseSerializerProvider, "tBaseSerializerProvider");
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
    }

    public EnhancedDataSender<MetaDataType> get() {
        PinpointClientFactory clientFactory = (PinpointClientFactory)this.clientFactoryProvider.get();
        String collectorTcpServerIp = this.thriftTransportConfig.getCollectorTcpServerIp();
        int collectorTcpServerPort = this.thriftTransportConfig.getCollectorTcpServerPort();
        HeaderTBaseSerializer headerTBaseSerializer = (HeaderTBaseSerializer)this.tBaseSerializerProvider.get();
        ThriftMessageSerializer<MetaDataType> messageSerializer = new ThriftMessageSerializer<MetaDataType>(this.messageConverter, (TBaseSerializer)headerTBaseSerializer);
        return new TcpDataSender<MetaDataType>("Default", collectorTcpServerIp, collectorTcpServerPort, clientFactory, messageSerializer);
    }
}

