/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class SpanStatConnectTimerProvider
implements Provider<Timer> {
    private final ThriftTransportConfig thriftTransportConfig;

    @Inject
    public SpanStatConnectTimerProvider(ThriftTransportConfig thriftTransportConfig) {
        this.thriftTransportConfig = Objects.requireNonNull(thriftTransportConfig, "thriftTransportConfig");
    }

    public Timer get() {
        if ("TCP".equalsIgnoreCase(this.thriftTransportConfig.getSpanDataSenderTransportType()) || "TCP".equalsIgnoreCase(this.thriftTransportConfig.getStatDataSenderTransportType())) {
            return SpanStatConnectTimerProvider.createTimer("Pinpoint-SpanStatConnect-Timer");
        }
        return null;
    }

    private static Timer createTimer(String timerName) {
        HashedWheelTimer timer = TimerFactory.createHashedWheelTimer((String)timerName, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (int)512);
        timer.start();
        return timer;
    }
}

