/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.module.SpanStatChannelFactory;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.rpc.client.ClientChannelFactory;
import java.util.Objects;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.util.Timer;

public class SpanStatChannelFactoryProvider
implements Provider<ChannelFactory> {
    private final ThriftTransportConfig thriftTransportConfig;
    private final Provider<Timer> connectTimerProvider;

    @Inject
    public SpanStatChannelFactoryProvider(ThriftTransportConfig thriftTransportConfig, @SpanStatChannelFactory Provider<Timer> connectTimerProvider) {
        this.thriftTransportConfig = Objects.requireNonNull(thriftTransportConfig, "thriftTransportConfig");
        this.connectTimerProvider = Objects.requireNonNull(connectTimerProvider, "connectTimerProvider");
    }

    public ChannelFactory get() {
        int workerCount = 0;
        if ("TCP".equalsIgnoreCase(this.thriftTransportConfig.getSpanDataSenderTransportType())) {
            ++workerCount;
        }
        if ("TCP".equalsIgnoreCase(this.thriftTransportConfig.getStatDataSenderTransportType())) {
            ++workerCount;
        }
        if (workerCount == 0) {
            return null;
        }
        Timer timer = (Timer)this.connectTimerProvider.get();
        ClientChannelFactory clientChannelFactory = new ClientChannelFactory();
        return clientChannelFactory.createChannelFactory(1, workerCount, timer);
    }
}

