/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.module.AgentDataSender;
import com.navercorp.pinpoint.profiler.context.module.DefaultClientFactory;
import com.navercorp.pinpoint.profiler.context.module.ModuleLifeCycle;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.module.SpanStatChannelFactory;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.receiver.CommandDispatcher;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import java.util.Objects;
import java.util.Set;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.util.Timer;

public class ThriftModuleLifeCycle
implements ModuleLifeCycle {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final Provider<CommandDispatcher> commandDispatcherProvider;
    private final Provider<PinpointClientFactory> clientFactoryProvider;
    private final Provider<EnhancedDataSender<MetaDataType>> tcpDataSenderProvider;
    private final Provider<Timer> spanStatConnectTimerProvider;
    private final Provider<ChannelFactory> spanStatChannelFactoryProvider;
    private final Provider<PinpointClientFactory> spanClientFactoryProvider;
    private final Provider<PinpointClientFactory> statClientFactoryProvider;
    private final Provider<DataSender<SpanType>> spanDataSenderProvider;
    private final Provider<DataSender<MetricType>> statDataSenderProvider;
    private CommandDispatcher commandDispatcher;
    private PinpointClientFactory clientFactory;
    private EnhancedDataSender<MetaDataType> tcpDataSender;
    private Timer spanStatConnectTimer;
    private ChannelFactory spanStatChannelFactory;
    private PinpointClientFactory spanClientFactory;
    private PinpointClientFactory statClientFactory;
    private DataSender<SpanType> spanDataSender;
    private DataSender<MetricType> statDataSender;

    @Inject
    public ThriftModuleLifeCycle(Provider<CommandDispatcher> commandDispatcherProvider, @DefaultClientFactory Provider<PinpointClientFactory> clientFactoryProvider, @AgentDataSender Provider<EnhancedDataSender<MetaDataType>> tcpDataSenderProvider, @SpanStatChannelFactory Provider<Timer> spanStatConnectTimerProvider, @SpanStatChannelFactory Provider<ChannelFactory> spanStatChannelFactoryProvider, @SpanDataSender Provider<PinpointClientFactory> spanClientFactoryProvider, @StatDataSender Provider<PinpointClientFactory> statClientFactoryProvider, @SpanDataSender Provider<DataSender<SpanType>> spanDataSenderProvider, @StatDataSender Provider<DataSender<MetricType>> statDataSenderProvider) {
        this.commandDispatcherProvider = Objects.requireNonNull(commandDispatcherProvider, "commandDispatcherProvider");
        this.clientFactoryProvider = Objects.requireNonNull(clientFactoryProvider, "clientFactoryProvider");
        this.tcpDataSenderProvider = Objects.requireNonNull(tcpDataSenderProvider, "tcpDataSenderProvider");
        this.spanStatConnectTimerProvider = Objects.requireNonNull(spanStatConnectTimerProvider, "spanStatConnectTimerProvider");
        this.spanStatChannelFactoryProvider = Objects.requireNonNull(spanStatChannelFactoryProvider, "spanStatChannelFactoryProvider");
        this.spanClientFactoryProvider = Objects.requireNonNull(spanClientFactoryProvider, "spanClientFactoryProvider");
        this.statClientFactoryProvider = Objects.requireNonNull(statClientFactoryProvider, "statClientFactoryProvider");
        this.spanDataSenderProvider = Objects.requireNonNull(spanDataSenderProvider, "spanDataSenderProvider");
        this.statDataSenderProvider = Objects.requireNonNull(statDataSenderProvider, "statDataSenderProvider");
    }

    @Override
    public void start() {
        this.logger.info("start()");
        this.commandDispatcher = (CommandDispatcher)((Object)this.commandDispatcherProvider.get());
        this.logger.info("commandDispatcher:{}", (Object)this.commandDispatcher);
        this.clientFactory = (PinpointClientFactory)this.clientFactoryProvider.get();
        this.logger.info("pinpointClientFactory:{}", (Object)this.clientFactory);
        this.tcpDataSender = (EnhancedDataSender)this.tcpDataSenderProvider.get();
        this.logger.info("tcpDataSenderProvider:{}", this.tcpDataSender);
        this.spanStatConnectTimer = (Timer)this.spanStatConnectTimerProvider.get();
        this.logger.info("spanStatConnectTimer:{}", (Object)this.spanStatConnectTimer);
        this.spanStatChannelFactory = (ChannelFactory)this.spanStatChannelFactoryProvider.get();
        this.logger.info("spanStatChannelFactory:{}", (Object)this.spanStatChannelFactory);
        this.spanClientFactory = (PinpointClientFactory)this.spanClientFactoryProvider.get();
        this.logger.info("spanClientFactory:{}", (Object)this.spanClientFactory);
        this.statClientFactory = (PinpointClientFactory)this.statClientFactoryProvider.get();
        this.logger.info("statClientFactory:{}", (Object)this.statClientFactory);
        this.spanDataSender = (DataSender)this.spanDataSenderProvider.get();
        this.logger.info("spanDataSenderProvider:{}", this.spanDataSender);
        this.statDataSender = (DataSender)this.statDataSenderProvider.get();
        this.logger.info("statDataSenderProvider:{}", this.statDataSender);
    }

    @Override
    public void shutdown() {
        Set stop;
        this.logger.info("shutdown()");
        if (this.spanDataSender != null) {
            this.spanDataSender.stop();
        }
        if (this.statDataSender != null) {
            this.statDataSender.stop();
        }
        if (this.spanClientFactory != null) {
            this.spanClientFactory.release();
        }
        if (this.statClientFactory != null) {
            this.statClientFactory.release();
        }
        if (this.spanStatChannelFactory != null) {
            this.spanStatChannelFactory.releaseExternalResources();
        }
        if (this.spanStatConnectTimer != null && !(stop = this.spanStatConnectTimer.stop()).isEmpty()) {
            this.logger.info("stop Timeout:{}", (Object)stop.size());
        }
        if (this.tcpDataSender != null) {
            this.tcpDataSender.stop();
        }
        if (this.clientFactory != null) {
            this.clientFactory.release();
        }
        if (this.commandDispatcher != null) {
            this.commandDispatcher.close();
        }
    }

    public String toString() {
        return "ThriftModuleLifeCycle{commandDispatcherProvider=" + this.commandDispatcherProvider + ", clientFactoryProvider=" + this.clientFactoryProvider + ", tcpDataSenderProvider=" + this.tcpDataSenderProvider + ", spanStatConnectTimerProvider=" + this.spanStatConnectTimerProvider + ", spanStatChannelFactoryProvider=" + this.spanStatChannelFactoryProvider + ", spanClientFactoryProvider=" + this.spanClientFactoryProvider + ", statClientFactoryProvider=" + this.statClientFactoryProvider + ", spanDataSenderProvider=" + this.spanDataSenderProvider + ", statDataSenderProvider=" + this.statDataSenderProvider + '}';
    }
}

