/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.errorhandler;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.context.errorhandler.Descriptor;
import com.navercorp.pinpoint.profiler.context.errorhandler.DescriptorParser;
import com.navercorp.pinpoint.profiler.context.errorhandler.ErrorHandlerBuilder;
import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IgnoreErrorHandlerProvider
implements Provider<IgnoreErrorHandler> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;

    @Inject
    public IgnoreErrorHandlerProvider(ProfilerConfig profilerConfig) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
    }

    public IgnoreErrorHandler get() {
        Map errorHandlerOption = this.profilerConfig.readPattern("^(profiler).(ignore-error-handler).([A-Za-z0-9\\-_]+).([A-Za-z0-9\\-_.@]+)");
        this.logger.info("IgnoreErrorHandler Option:{}", (Object)errorHandlerOption);
        DescriptorParser parser = new DescriptorParser(errorHandlerOption);
        List<Descriptor> descriptors = parser.parse();
        this.logger.info("IgnoreErrorHandler Descriptors:{}", descriptors);
        ErrorHandlerBuilder builder = new ErrorHandlerBuilder(descriptors);
        IgnoreErrorHandler errorHandler = builder.build();
        this.logger.info("IgnoreErrorHandler:{}", (Object)errorHandler);
        return errorHandler;
    }
}

