/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.errorhandler;

import com.navercorp.pinpoint.profiler.context.errorhandler.ThrowableMatcher;
import java.util.Arrays;
import java.util.Objects;

public class ClassNameThrowableMatcher
implements ThrowableMatcher {
    private final String[] classPatterns;

    public ClassNameThrowableMatcher(String[] classPatterns) {
        this.classPatterns = Objects.requireNonNull(classPatterns, "classPattern");
    }

    @Override
    public boolean match(Class<? extends Throwable> throwableClass) {
        if (throwableClass == null) {
            return false;
        }
        String name = throwableClass.getName();
        for (String classPattern : this.classPatterns) {
            if (!classPattern.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ClassNameThrowableMatcher{classPatterns=" + Arrays.toString(this.classPatterns) + '}';
    }
}

