/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.annotation;

import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.grpc.trace.PAnnotationValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationSerializable;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.thrift.AnnotationValueThriftMapper;
import com.navercorp.pinpoint.profiler.context.thrift.ThriftAnnotationSerializable;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;

public class ObjectAnnotation
implements Annotation<Object>,
GrpcAnnotationSerializable,
ThriftAnnotationSerializable {
    private final int key;
    private final String value;

    ObjectAnnotation(int key, Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.key = key;
        this.value = StringUtils.abbreviate((String)value.toString());
    }

    @Override
    public int getAnnotationKey() {
        return this.getKey();
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public PAnnotationValue apply(GrpcAnnotationValueMapper context) {
        PAnnotationValue.Builder builder = context.getAnnotationBuilder();
        builder.setStringValue(this.value);
        return builder.build();
    }

    @Override
    public TAnnotationValue apply(AnnotationValueThriftMapper context) {
        return TAnnotationValue.stringValue((String)this.value);
    }

    public String toString() {
        return "ObjectAnnotation{" + this.key + "=" + this.value + '}';
    }
}

