/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.active;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.navercorp.pinpoint.common.trace.BaseHistogramSchema;
import com.navercorp.pinpoint.common.trace.HistogramSchema;
import com.navercorp.pinpoint.common.trace.HistogramSlot;
import com.navercorp.pinpoint.profiler.context.active.ActiveTrace;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.active.DefaultActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.EmptyActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.SampledActiveTrace;
import com.navercorp.pinpoint.profiler.context.active.UnsampledActiveTrace;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultActiveTraceRepository
implements ActiveTraceRepository {
    private static final int DEFAULT_MAX_ACTIVE_TRACE_SIZE = 10240;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final ConcurrentMap<ActiveTraceHandle, ActiveTrace> activeTraceInfoMap;
    private final ResponseTimeCollector responseTimeCollector;
    private final HistogramSchema histogramSchema = BaseHistogramSchema.NORMAL_SCHEMA;
    private final ActiveTraceHistogram emptyActiveTraceHistogram = new EmptyActiveTraceHistogram(this.histogramSchema);

    public DefaultActiveTraceRepository(ResponseTimeCollector responseTimeCollector) {
        this(responseTimeCollector, 10240);
    }

    public DefaultActiveTraceRepository(ResponseTimeCollector responseTimeCollector, int maxActiveTraceSize) {
        this.responseTimeCollector = Objects.requireNonNull(responseTimeCollector, "responseTimeCollector");
        this.activeTraceInfoMap = this.createCache(maxActiveTraceSize);
    }

    private ConcurrentMap<ActiveTraceHandle, ActiveTrace> createCache(int maxActiveTraceSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.concurrencyLevel(64);
        cacheBuilder.initialCapacity(maxActiveTraceSize);
        cacheBuilder.maximumSize((long)maxActiveTraceSize);
        Cache localCache = cacheBuilder.build();
        return localCache.asMap();
    }

    private void remove(ActiveTraceHandle key, long purgeTime) {
        ActiveTrace activeTrace;
        if (this.isDebug) {
            this.logger.debug("remove ActiveTrace key:{}", (Object)key);
        }
        if ((activeTrace = (ActiveTrace)this.activeTraceInfoMap.remove(key)) != null) {
            long responseTime = purgeTime - activeTrace.getStartTime();
            this.responseTimeCollector.add(responseTime);
        }
    }

    @Override
    public ActiveTraceHandle register(TraceRoot traceRoot) {
        ActiveTrace activeTrace = this.newSampledActiveTrace(traceRoot);
        return this.register0(activeTrace);
    }

    private ActiveTrace newSampledActiveTrace(TraceRoot traceRoot) {
        return new SampledActiveTrace(traceRoot);
    }

    @Override
    public ActiveTraceHandle register(long localTransactionId, long startTime, long threadId) {
        ActiveTrace activeTrace = this.newUnsampledActiveTrace(localTransactionId, startTime, threadId);
        return this.register0(activeTrace);
    }

    private ActiveTrace newUnsampledActiveTrace(long localTransactionId, long startTime, long threadId) {
        return new UnsampledActiveTrace(localTransactionId, startTime, threadId);
    }

    private ActiveTraceHandle register0(ActiveTrace activeTrace) {
        long id;
        DefaultActiveTraceHandle handle;
        ActiveTrace old;
        if (this.isDebug) {
            this.logger.debug("register ActiveTrace key:{}", (Object)activeTrace);
        }
        if ((old = this.activeTraceInfoMap.put(handle = new DefaultActiveTraceHandle(id = activeTrace.getId()), activeTrace)) != null && this.logger.isWarnEnabled()) {
            this.logger.warn("old activeTrace exist:{}", (Object)old);
        }
        return handle;
    }

    @Override
    public List<ActiveTraceSnapshot> snapshot() {
        if (this.activeTraceInfoMap.isEmpty()) {
            return Collections.emptyList();
        }
        Collection activeTraceCollection = this.activeTraceInfoMap.values();
        ArrayList<ActiveTraceSnapshot> collectData = new ArrayList<ActiveTraceSnapshot>(activeTraceCollection.size());
        for (ActiveTrace trace : activeTraceCollection) {
            long startTime = trace.getStartTime();
            if (!this.isStarted(startTime)) continue;
            ActiveTraceSnapshot snapshot = trace.snapshot();
            collectData.add(snapshot);
        }
        if (this.isDebug) {
            this.logger.debug("activeTraceSnapshot size:{}", (Object)collectData.size());
        }
        return collectData;
    }

    @Override
    public List<Long> getThreadIdList() {
        if (this.activeTraceInfoMap.isEmpty()) {
            return Collections.emptyList();
        }
        Collection activeTraceCollection = this.activeTraceInfoMap.values();
        ArrayList<Long> collectData = new ArrayList<Long>(activeTraceCollection.size());
        for (ActiveTrace trace : activeTraceCollection) {
            long startTime = trace.getStartTime();
            if (!this.isStarted(startTime)) continue;
            ActiveTraceSnapshot snapshot = trace.snapshot();
            collectData.add(snapshot.getThreadId());
        }
        if (this.isDebug) {
            this.logger.debug("activeTraceSnapshot size:{}", (Object)collectData.size());
        }
        return collectData;
    }

    @Override
    public ActiveTraceHistogram getActiveTraceHistogram(long currentTime) {
        if (this.activeTraceInfoMap.isEmpty()) {
            return this.emptyActiveTraceHistogram;
        }
        Collection activeTraceCollection = this.activeTraceInfoMap.values();
        DefaultActiveTraceHistogram histogram = new DefaultActiveTraceHistogram(this.histogramSchema);
        for (ActiveTrace activeTraceInfo : activeTraceCollection) {
            long startTime = activeTraceInfo.getStartTime();
            if (!this.isStarted(startTime)) continue;
            int elapsedTime = (int)(currentTime - startTime);
            HistogramSlot slot = this.histogramSchema.findHistogramSlot(elapsedTime, false);
            histogram.increment(slot);
        }
        return histogram;
    }

    private boolean isStarted(long startTime) {
        return startTime > 0L;
    }

    private class DefaultActiveTraceHandle
    implements ActiveTraceHandle {
        private final long id;

        DefaultActiveTraceHandle(long id) {
            this.id = id;
        }

        @Override
        public void purge(long purgeTime) {
            DefaultActiveTraceRepository.this.remove(this, purgeTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultActiveTraceHandle that = (DefaultActiveTraceHandle)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public String toString() {
            return "DefaultActiveTraceHandle{id=" + this.id + '}';
        }
    }
}

