/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.active;

import com.navercorp.pinpoint.common.trace.HistogramSchema;
import com.navercorp.pinpoint.common.trace.HistogramSlot;
import com.navercorp.pinpoint.common.trace.SlotType;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import java.util.Objects;

public class DefaultActiveTraceHistogram
implements ActiveTraceHistogram {
    private final HistogramSchema histogramSchema;
    private int fastCount;
    private int normalCount;
    private int slowCount;
    private int verySlowCount;

    public DefaultActiveTraceHistogram(HistogramSchema histogramSchema) {
        this.histogramSchema = Objects.requireNonNull(histogramSchema, "histogramSchema");
    }

    public void increment(HistogramSlot slot) {
        Objects.requireNonNull(slot, "slot");
        SlotType slotType = slot.getSlotType();
        switch (slotType) {
            case FAST: {
                ++this.fastCount;
                return;
            }
            case NORMAL: {
                ++this.normalCount;
                return;
            }
            case SLOW: {
                ++this.slowCount;
                return;
            }
            case VERY_SLOW: {
                ++this.verySlowCount;
                return;
            }
        }
        throw new UnsupportedOperationException("slot type:" + slot);
    }

    @Override
    public HistogramSchema getHistogramSchema() {
        return this.histogramSchema;
    }

    @Override
    public int getFastCount() {
        return this.fastCount;
    }

    @Override
    public int getNormalCount() {
        return this.normalCount;
    }

    @Override
    public int getSlowCount() {
        return this.slowCount;
    }

    @Override
    public int getVerySlowCount() {
        return this.verySlowCount;
    }
}

