/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import java.util.Objects;

public class DisableTrace
implements Trace {
    public static final String UNSUPPORTED_OPERATION = "disable trace";
    public static final long DISABLE_TRACE_OBJECT_ID = -1L;
    private final long id;
    private final long startTime;
    private DefaultTraceScopePool scopePool;
    private final ActiveTraceHandle handle;
    private boolean closed = false;

    public DisableTrace(long id, long startTime, ActiveTraceHandle handle) {
        this.id = id;
        this.startTime = startTime;
        this.handle = Objects.requireNonNull(handle, "handle");
    }

    public long getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public SpanEventRecorder traceBlockBegin() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void traceBlockEnd() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void traceBlockEnd(int stackId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public TraceId getTraceId() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public boolean canSampled() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isAsync() {
        return false;
    }

    public boolean isRootStack() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        long purgeTime = System.currentTimeMillis();
        this.handle.purge(purgeTime);
    }

    public int getCallStackFrameId() {
        return 0;
    }

    public SpanRecorder getSpanRecorder() {
        return null;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        return null;
    }

    public TraceScope getScope(String name) {
        if (this.scopePool == null) {
            return null;
        }
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        if (this.scopePool == null) {
            this.scopePool = new DefaultTraceScopePool();
        }
        return this.scopePool.add(name);
    }
}

