/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.mongodb.consumer;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.storage.mongodb.client.MongodbClientManager;
import org.apache.eventmesh.storage.mongodb.config.ConfigurationHolder;
import org.apache.eventmesh.storage.mongodb.utils.MongodbCloudEventUtil;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbStandaloneConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(MongodbStandaloneConsumer.class);
    private final ConfigurationHolder configurationHolder;
    private volatile boolean started = false;
    private EventListener eventListener;
    private MongoClient client;
    private MongoDatabase db;
    private MongoCollection<Document> cappedCol;
    private SubTask task = new SubTask();
    private final ThreadPoolExecutor executor = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"EventMesh-Mongodb-StandaloneConsumer-");

    public MongodbStandaloneConsumer(ConfigurationHolder configurationHolder) {
        this.configurationHolder = configurationHolder;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    public void shutdown() {
        if (this.started) {
            try {
                MongodbClientManager.closeMongodbClient(this.client);
            }
            finally {
                this.started = false;
            }
        }
    }

    public void init(Properties keyValue) {
        this.client = MongodbClientManager.createMongodbClient(this.configurationHolder.getUrl());
        this.db = this.client.getDatabase(this.configurationHolder.getDatabase());
        this.cappedCol = this.db.getCollection(this.configurationHolder.getCollection());
        Document index = new Document("ts", (Object)1).append("topic", (Object)1);
        this.cappedCol.createIndex((Bson)index);
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
    }

    public void subscribe(String topic) {
        this.task = new SubTask();
        this.executor.execute(this.task);
    }

    public void unsubscribe(String topic) {
        this.task.stop();
    }

    public void registerEventListener(EventListener listener) {
        this.eventListener = listener;
    }

    private FindIterable<Document> getCursor(MongoCollection<Document> collection, String topic, int lastId) {
        Document index = new Document("$gt", (Object)lastId);
        Document ts = new Document("ts", (Object)index);
        Document spec = ts.append("topic", (Object)topic);
        FindIterable documents = collection.find((Bson)spec);
        return documents;
    }

    private class SubTask
    implements Runnable {
        private final AtomicBoolean stop = new AtomicBoolean(false);

        private SubTask() {
        }

        @Override
        public void run() {
            int lastId = -1;
            while (!this.stop.get()) {
                try {
                    FindIterable cur = MongodbStandaloneConsumer.this.getCursor((MongoCollection<Document>)MongodbStandaloneConsumer.this.cappedCol, "flag", lastId);
                    for (Document obj : cur) {
                        CloudEvent cloudEvent = MongodbCloudEventUtil.convertToCloudEvent(obj);
                        EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

                            public void commit(EventMeshAction action) {
                                log.info("[MongodbStandaloneConsumer] Mongodb consumer context commit.");
                            }
                        };
                        if (MongodbStandaloneConsumer.this.eventListener != null) {
                            MongodbStandaloneConsumer.this.eventListener.consume(cloudEvent, (AsyncConsumeContext)consumeContext);
                        }
                        try {
                            lastId = (int)((Double)obj.get((Object)"ts")).doubleValue();
                        }
                        catch (ClassCastException ce) {
                            lastId = (Integer)obj.get((Object)"ts");
                        }
                    }
                }
                catch (Exception ex) {
                    log.error("[MongodbStandaloneConsumer] thread run happen exception.", (Throwable)ex);
                }
                Thread.yield();
            }
        }

        public void stop() {
            this.stop.set(true);
        }
    }
}

