/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.storage.StorageResourceService;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageResource {
    private static final Logger log = LoggerFactory.getLogger(StorageResource.class);
    private static final Map<String, StorageResource> STORAGE_RESOURCE_CACHE = new HashMap<String, StorageResource>(16);
    private StorageResourceService storageResourceService;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final AtomicBoolean released = new AtomicBoolean(false);

    private StorageResource() {
    }

    public static StorageResource getInstance(String storageResourcePluginType) {
        return STORAGE_RESOURCE_CACHE.computeIfAbsent(storageResourcePluginType, StorageResource::storageResourceBuilder);
    }

    private static StorageResource storageResourceBuilder(String storageResourcePluginType) {
        StorageResourceService storageResourceServiceExt = (StorageResourceService)EventMeshExtensionFactory.getExtension(StorageResourceService.class, (String)storageResourcePluginType);
        if (storageResourceServiceExt == null) {
            String errorMsg = "can't load the StorageResourceService plugin, please check.";
            log.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        StorageResource storageResource = new StorageResource();
        storageResource.storageResourceService = storageResourceServiceExt;
        return storageResource;
    }

    public void init() throws Exception {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.storageResourceService.init();
    }

    public void release() throws Exception {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        this.inited.compareAndSet(true, false);
        this.storageResourceService.release();
    }
}

