/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.auth.ram.RamContext;
import com.alibaba.nacos.client.auth.ram.identify.StsConfig;
import com.alibaba.nacos.client.auth.ram.injector.AbstractResourceInjector;
import com.alibaba.nacos.client.auth.ram.injector.ConfigResourceInjector;
import com.alibaba.nacos.client.auth.ram.injector.NamingResourceInjector;
import com.alibaba.nacos.client.auth.ram.utils.SpasAdapter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.alibaba.nacos.plugin.auth.spi.client.AbstractClientAuthService;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamClientAuthServiceImpl
extends AbstractClientAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RamClientAuthServiceImpl.class);
    private final RamContext ramContext = new RamContext();
    private final Map<String, AbstractResourceInjector> resourceInjectors = new HashMap<String, AbstractResourceInjector>();

    public RamClientAuthServiceImpl() {
        this.resourceInjectors.put("naming", new NamingResourceInjector());
        this.resourceInjectors.put("config", new ConfigResourceInjector());
    }

    public Boolean login(Properties properties) {
        if (this.ramContext.validate()) {
            return true;
        }
        this.loadRoleName(properties);
        this.loadAccessKey(properties);
        this.loadSecretKey(properties);
        return true;
    }

    private void loadRoleName(Properties properties) {
        String ramRoleName = properties.getProperty("ramRoleName");
        if (!StringUtils.isBlank(ramRoleName)) {
            StsConfig.getInstance().setRamRoleName(ramRoleName);
            this.ramContext.setRamRoleName(ramRoleName);
        }
    }

    private void loadAccessKey(Properties properties) {
        String accessKey = properties.getProperty("accessKey");
        this.ramContext.setAccessKey(StringUtils.isBlank(accessKey) ? SpasAdapter.getAk() : accessKey);
    }

    private void loadSecretKey(Properties properties) {
        String secretKey = properties.getProperty("secretKey");
        this.ramContext.setSecretKey(StringUtils.isBlank(secretKey) ? SpasAdapter.getSk() : secretKey);
    }

    public LoginIdentityContext getLoginIdentityContext(RequestResource resource) {
        LoginIdentityContext result = new LoginIdentityContext();
        if (!this.ramContext.validate() || this.notFountInjector(resource.getType())) {
            return result;
        }
        this.resourceInjectors.get(resource.getType()).doInject(resource, this.ramContext, result);
        return result;
    }

    private boolean notFountInjector(String type) {
        if (!this.resourceInjectors.containsKey(type)) {
            LOGGER.warn("Injector for type {} not found, will use default ram identity context.", (Object)type);
            return true;
        }
        return false;
    }

    public void shutdown() throws NacosException {
        SpasAdapter.freeCredentialInstance();
    }
}

