/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public class MyX509TrustManager
implements X509TrustManager {
    private transient X509TrustManager myTrustManager;

    public MyX509TrustManager() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        TrustManager[] trustManagers;
        KeyStore keyStore = KeyStore.getInstance("JKS");
        String fileName = System.getProperty("ssl.client.cer", "");
        String pass = System.getProperty("ssl.client.pass", "");
        char[] filePass = StringUtils.isNotBlank((CharSequence)pass) ? pass.toCharArray() : new char[]{};
        try (InputStream in = Files.newInputStream(Paths.get(System.getProperty("confPath", System.getenv("confPath")) + File.separator + fileName, new String[0]), StandardOpenOption.READ);){
            keyStore.load(in, filePass);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        for (TrustManager trustManager : trustManagers = trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            this.myTrustManager = (X509TrustManager)trustManager;
            return;
        }
        throw new KeyStoreException("Couldn't initialize");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && certificates.length == 1) {
            certificates[0].checkValidity();
        } else {
            this.myTrustManager.checkServerTrusted(certificates, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.myTrustManager.getAcceptedIssuers();
    }
}

