/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateCode;
import java.util.concurrent.atomic.AtomicReference;

public class StreamChannelState {
    private final AtomicReference<StreamChannelStateCode> currentStateReference = new AtomicReference();

    public StreamChannelState() {
        this.currentStateReference.set(StreamChannelStateCode.NEW);
    }

    public StreamChannelStateCode getCurrentState() {
        return this.currentStateReference.get();
    }

    boolean to(StreamChannelStateCode nextState) {
        return this.to(this.currentStateReference.get(), nextState);
    }

    boolean to(StreamChannelStateCode currentState, StreamChannelStateCode nextState) {
        if (!nextState.canChangeState(currentState)) {
            return false;
        }
        boolean isChanged = this.currentStateReference.compareAndSet(currentState, nextState);
        return isChanged;
    }

    public boolean checkState(StreamChannelStateCode expectedCode) {
        return this.checkState(this.getCurrentState(), expectedCode);
    }

    public boolean checkState(StreamChannelStateCode currentCode, StreamChannelStateCode expectedCode) {
        return currentCode == expectedCode;
    }

    public void assertState(StreamChannelStateCode stateCode) {
        StreamChannelStateCode currentCode = this.getCurrentState();
        if (!this.checkState(currentCode, stateCode)) {
            throw new PinpointSocketException("expected:<" + (Object)((Object)stateCode) + "> but was:<" + (Object)((Object)currentCode) + ">;");
        }
    }

    public String toString() {
        return this.currentStateReference.get().name();
    }
}

