/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet.stream;

import com.navercorp.pinpoint.rpc.packet.PayloadPacket;
import com.navercorp.pinpoint.rpc.packet.stream.BasicStreamPacket;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class StreamResponsePacket
extends BasicStreamPacket {
    private static final short PACKET_TYPE = 20;
    private final byte[] payload;

    public StreamResponsePacket(int streamChannelId, byte[] payload) {
        super(streamChannelId);
        Objects.requireNonNull(payload, "payload");
        this.payload = payload;
    }

    @Override
    public short getPacketType() {
        return 20;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer((int)10);
        header.writeShort((int)this.getPacketType());
        header.writeInt(this.getStreamChannelId());
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static StreamResponsePacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 20);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int streamChannelId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        StreamResponsePacket packet = new StreamResponsePacket(streamChannelId, payload.array());
        return packet;
    }
}

