/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet.stream;

import com.navercorp.pinpoint.rpc.packet.stream.BasicStreamPacket;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class StreamPingPacket
extends BasicStreamPacket {
    private static final short PACKET_TYPE = 17;
    private final int requestId;

    public StreamPingPacket(int streamChannelId, int requestId) {
        super(streamChannelId);
        this.requestId = requestId;
    }

    @Override
    public short getPacketType() {
        return 17;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer((int)10);
        header.writeShort((int)this.getPacketType());
        header.writeInt(this.getStreamChannelId());
        header.writeInt(this.requestId);
        return header;
    }

    public static StreamPingPacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 17);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int streamChannelId = buffer.readInt();
        int requestId = buffer.readInt();
        StreamPingPacket packet = new StreamPingPacket(streamChannelId, requestId);
        return packet;
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{streamChannelId=").append(this.getStreamChannelId());
        sb.append(", ");
        sb.append("streamChannelId=").append(this.getRequestId());
        sb.append('}');
        return sb.toString();
    }
}

