/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import com.navercorp.pinpoint.rpc.packet.BasicPacket;
import com.navercorp.pinpoint.rpc.packet.PayloadPacket;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ControlHandshakePacket
extends BasicPacket {
    private final int requestId;

    public ControlHandshakePacket(int requestId, byte[] payload) {
        super(payload);
        this.requestId = requestId;
    }

    @Override
    public short getPacketType() {
        return 150;
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer((int)10);
        header.writeShort(150);
        header.writeInt(this.getRequestId());
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static ControlHandshakePacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 150);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int messageId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        ControlHandshakePacket helloPacket = new ControlHandshakePacket(messageId, payload.array());
        return helloPacket;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{requestId=").append(this.getRequestId());
        sb.append(", ");
        if (this.payload == null) {
            sb.append("payload=null");
        } else {
            sb.append("payloadLength=").append(this.payload.length);
        }
        sb.append('}');
        return sb.toString();
    }
}

