/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.control;

import com.navercorp.pinpoint.rpc.control.ProtocolException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ControlMessageEncoder {
    private final Charset charset = StandardCharsets.UTF_8;

    public byte[] encode(Map<String, Object> value) throws ProtocolException {
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer((int)100);
        this.encode(value, cb);
        int writeIndex = cb.writerIndex();
        byte[] result = new byte[writeIndex];
        cb.readBytes(result);
        return result;
    }

    private void encode(Map<String, Object> value, ChannelBuffer cb) throws ProtocolException {
        this.encodeMap(value, cb);
    }

    private void encode(Object value, ChannelBuffer cb) throws ProtocolException {
        if (value == null) {
            this.encodeNull(cb);
        } else if (value instanceof String) {
            this.encodeString((String)value, cb);
        } else if (value instanceof Boolean) {
            this.encodeBoolean((Boolean)value, cb);
        } else if (value instanceof Short) {
            this.encodeInt(((Short)value).shortValue(), cb);
        } else if (value instanceof Integer) {
            this.encodeInt((Integer)value, cb);
        } else if (value instanceof Long) {
            this.encodeLong((Long)value, cb);
        } else if (value instanceof Float) {
            this.encodeDouble(((Float)value).doubleValue(), cb);
        } else if (value instanceof Double) {
            this.encodeDouble((Double)value, cb);
        } else if (value instanceof Number) {
            this.encodeString(value.toString(), cb);
        } else if (value instanceof Collection) {
            this.encodeCollection((Collection)value, cb);
        } else if (value instanceof Map) {
            this.encodeMap((Map)value, cb);
        } else if (value.getClass().isArray()) {
            int arraySize = Array.getLength(value);
            ArrayList<Object> arrayToList = new ArrayList<Object>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                arrayToList.add(Array.get(value, i));
            }
            this.encodeCollection(arrayToList, cb);
        } else {
            throw new ProtocolException("Unsupported type : " + value.getClass().getName());
        }
    }

    private void encodeNull(ChannelBuffer out) {
        out.writeByte(78);
    }

    private void encodeString(String value, ChannelBuffer out) {
        out.writeByte(83);
        this.putPrefixedBytes(value.getBytes(this.charset), out);
    }

    private void encodeBoolean(boolean value, ChannelBuffer out) {
        if (value) {
            out.writeByte(84);
        } else {
            out.writeByte(70);
        }
    }

    private void encodeInt(int value, ChannelBuffer out) {
        out.writeByte(73);
        out.writeByte((int)((byte)(value >> 24)));
        out.writeByte((int)((byte)(value >> 16)));
        out.writeByte((int)((byte)(value >> 8)));
        out.writeByte((int)((byte)value));
    }

    private void encodeLong(long value, ChannelBuffer out) {
        out.writeByte(76);
        out.writeByte((int)((byte)(value >> 56)));
        out.writeByte((int)((byte)(value >> 48)));
        out.writeByte((int)((byte)(value >> 40)));
        out.writeByte((int)((byte)(value >> 32)));
        out.writeByte((int)((byte)(value >> 24)));
        out.writeByte((int)((byte)(value >> 16)));
        out.writeByte((int)((byte)(value >> 8)));
        out.writeByte((int)((byte)value));
    }

    private void encodeDouble(double value, ChannelBuffer out) {
        out.writeByte(68);
        long longValue = Double.doubleToLongBits(value);
        out.writeByte((int)((byte)(longValue >> 56)));
        out.writeByte((int)((byte)(longValue >> 48)));
        out.writeByte((int)((byte)(longValue >> 40)));
        out.writeByte((int)((byte)(longValue >> 32)));
        out.writeByte((int)((byte)(longValue >> 24)));
        out.writeByte((int)((byte)(longValue >> 16)));
        out.writeByte((int)((byte)(longValue >> 8)));
        out.writeByte((int)((byte)longValue));
    }

    private void encodeCollection(Collection<?> collection, ChannelBuffer out) throws ProtocolException {
        out.writeByte(86);
        for (Object element : collection) {
            this.encode(element, out);
        }
        out.writeByte(122);
    }

    private void encodeMap(Map<?, ?> map, ChannelBuffer out) throws ProtocolException {
        out.writeByte(77);
        Iterator<Map.Entry<?, ?>> i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<?, ?> element;
            Map.Entry<?, ?> entry = element = i$.next();
            this.encode(entry.getKey(), out);
            this.encode(entry.getValue(), out);
        }
        out.writeByte(122);
    }

    private void putPrefixedBytes(byte[] value, ChannelBuffer out) {
        int length = value.length;
        byte[] lengthBuf = new byte[5];
        int idx = 0;
        while (true) {
            if ((length & 0xFFFFFF80) == 0) break;
            lengthBuf[idx++] = (byte)(length & 0x7F | 0x80);
            length >>>= 7;
        }
        lengthBuf[idx++] = (byte)length;
        for (int i = 0; i < idx; ++i) {
            out.writeByte((int)lengthBuf[i]);
        }
        out.writeBytes(value);
    }
}

