/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.codec;

import com.navercorp.pinpoint.rpc.codec.PacketDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;

public class ServerPacketDecoder
extends PacketDecoder {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 2) {
            return null;
        }
        buffer.markReaderIndex();
        short packetType = buffer.readShort();
        switch (packetType) {
            case 1: {
                return this.readSend(packetType, buffer);
            }
            case 5: {
                return this.readRequest(packetType, buffer);
            }
            case 6: {
                return this.readResponse(packetType, buffer);
            }
            case 10: {
                return this.readStreamCreate(packetType, buffer);
            }
            case 15: {
                return this.readStreamClose(packetType, buffer);
            }
            case 12: {
                return this.readStreamCreateSuccess(packetType, buffer);
            }
            case 14: {
                return this.readStreamCreateFail(packetType, buffer);
            }
            case 20: {
                return this.readStreamData(packetType, buffer);
            }
            case 17: {
                return this.readStreamPing(packetType, buffer);
            }
            case 18: {
                return this.readStreamPong(packetType, buffer);
            }
            case 100: {
                return this.readControlClientClose(packetType, buffer);
            }
            case 110: {
                return this.readControlServerClose(packetType, buffer);
            }
            case 210: {
                return this.readPing(packetType, buffer);
            }
            case 211: {
                return this.readPayloadPing(packetType, buffer);
            }
            case 200: {
                return this.readLegacyPing(packetType, buffer);
            }
            case 201: {
                this.logger.debug("receive pong. {}", (Object)channel);
                this.readPong(packetType, buffer);
                return null;
            }
            case 150: {
                return this.readEnableWorker(packetType, buffer);
            }
            case 151: {
                return this.readEnableWorkerConfirm(packetType, buffer);
            }
        }
        this.logger.error("invalid packetType received. packetType:{}, channel:{}", (Object)packetType, (Object)channel);
        channel.close();
        return null;
    }
}

