/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.codec;

import com.navercorp.pinpoint.rpc.client.WriteFailFutureListener;
import com.navercorp.pinpoint.rpc.packet.ClientClosePacket;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakePacket;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakeResponsePacket;
import com.navercorp.pinpoint.rpc.packet.PingPacket;
import com.navercorp.pinpoint.rpc.packet.PingPayloadPacket;
import com.navercorp.pinpoint.rpc.packet.PingSimplePacket;
import com.navercorp.pinpoint.rpc.packet.PongPacket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.ResponsePacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;
import com.navercorp.pinpoint.rpc.packet.ServerClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreateFailPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreatePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreateSuccessPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPingPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPongPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamResponsePacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class PacketDecoder
extends FrameDecoder {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final WriteFailFutureListener pongWriteFutureListener = new WriteFailFutureListener(this.logger, "pong write fail.", "pong write success.");

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 2) {
            return null;
        }
        buffer.markReaderIndex();
        short packetType = buffer.readShort();
        switch (packetType) {
            case 1: {
                return this.readSend(packetType, buffer);
            }
            case 5: {
                return this.readRequest(packetType, buffer);
            }
            case 6: {
                return this.readResponse(packetType, buffer);
            }
            case 10: {
                return this.readStreamCreate(packetType, buffer);
            }
            case 15: {
                return this.readStreamClose(packetType, buffer);
            }
            case 12: {
                return this.readStreamCreateSuccess(packetType, buffer);
            }
            case 14: {
                return this.readStreamCreateFail(packetType, buffer);
            }
            case 20: {
                return this.readStreamData(packetType, buffer);
            }
            case 17: {
                return this.readStreamPing(packetType, buffer);
            }
            case 18: {
                return this.readStreamPong(packetType, buffer);
            }
            case 100: {
                return this.readControlClientClose(packetType, buffer);
            }
            case 110: {
                return this.readControlServerClose(packetType, buffer);
            }
            case 210: {
                PingSimplePacket pingPacket = (PingSimplePacket)this.readPing(packetType, buffer);
                if (pingPacket == PingSimplePacket.PING_PACKET) {
                    this.sendPong(channel);
                    return null;
                }
            }
            case 211: {
                return this.readPayloadPing(packetType, buffer);
            }
            case 200: {
                PingPacket legacyPingPacket = (PingPacket)this.readLegacyPing(packetType, buffer);
                if (legacyPingPacket == PingPacket.PING_PACKET) {
                    this.sendPong(channel);
                    return null;
                }
                return legacyPingPacket;
            }
            case 201: {
                this.logger.debug("receive pong. {}", (Object)channel);
                this.readPong(packetType, buffer);
                return null;
            }
            case 150: {
                return this.readEnableWorker(packetType, buffer);
            }
            case 151: {
                return this.readEnableWorkerConfirm(packetType, buffer);
            }
        }
        this.logger.error("invalid packetType received. packetType:{}, channel:{}", (Object)packetType, (Object)channel);
        channel.close();
        return null;
    }

    private void sendPong(Channel channel) {
        this.logger.debug("received ping. sending pong. {}", (Object)channel);
        ChannelFuture write = channel.write((Object)PongPacket.PONG_PACKET);
        write.addListener((ChannelFutureListener)this.pongWriteFutureListener);
    }

    Object readControlClientClose(short packetType, ChannelBuffer buffer) {
        return ClientClosePacket.readBuffer(packetType, buffer);
    }

    Object readControlServerClose(short packetType, ChannelBuffer buffer) {
        return ServerClosePacket.readBuffer(packetType, buffer);
    }

    Object readPong(short packetType, ChannelBuffer buffer) {
        return PongPacket.readBuffer(packetType, buffer);
    }

    Object readPing(short packetType, ChannelBuffer buffer) {
        return PingSimplePacket.readBuffer(packetType, buffer);
    }

    Object readPayloadPing(short packetType, ChannelBuffer buffer) {
        return PingPayloadPacket.readBuffer(packetType, buffer);
    }

    @Deprecated
    Object readLegacyPing(short packetType, ChannelBuffer buffer) {
        return PingPacket.readBuffer(packetType, buffer);
    }

    Object readSend(short packetType, ChannelBuffer buffer) {
        return SendPacket.readBuffer(packetType, buffer);
    }

    Object readRequest(short packetType, ChannelBuffer buffer) {
        return RequestPacket.readBuffer(packetType, buffer);
    }

    Object readResponse(short packetType, ChannelBuffer buffer) {
        return ResponsePacket.readBuffer(packetType, buffer);
    }

    Object readStreamCreate(short packetType, ChannelBuffer buffer) {
        return StreamCreatePacket.readBuffer(packetType, buffer);
    }

    Object readStreamCreateSuccess(short packetType, ChannelBuffer buffer) {
        return StreamCreateSuccessPacket.readBuffer(packetType, buffer);
    }

    Object readStreamCreateFail(short packetType, ChannelBuffer buffer) {
        return StreamCreateFailPacket.readBuffer(packetType, buffer);
    }

    Object readStreamData(short packetType, ChannelBuffer buffer) {
        return StreamResponsePacket.readBuffer(packetType, buffer);
    }

    Object readStreamPong(short packetType, ChannelBuffer buffer) {
        return StreamPongPacket.readBuffer(packetType, buffer);
    }

    Object readStreamPing(short packetType, ChannelBuffer buffer) {
        return StreamPingPacket.readBuffer(packetType, buffer);
    }

    Object readStreamClose(short packetType, ChannelBuffer buffer) {
        return StreamClosePacket.readBuffer(packetType, buffer);
    }

    Object readEnableWorker(short packetType, ChannelBuffer buffer) {
        return ControlHandshakePacket.readBuffer(packetType, buffer);
    }

    Object readEnableWorkerConfirm(short packetType, ChannelBuffer buffer) {
        return ControlHandshakeResponsePacket.readBuffer(packetType, buffer);
    }
}

