/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.api;

import io.openmessaging.api.TopicPartition;
import java.io.Serializable;
import java.util.Properties;

public class Message
implements Serializable {
    private static final long serialVersionUID = -1385924226856188094L;
    protected Properties systemProperties;
    private String topic;
    private Properties userProperties;
    private byte[] body;

    public Message() {
        this(null, null, "", null);
    }

    public Message(String topic, String tag, String key, byte[] body) {
        this.topic = topic;
        this.body = body;
        this.putSystemProperties("__TAG", tag);
        this.putSystemProperties("__KEY", key);
    }

    public void putSystemProperties(String key, String value) {
        if (null == this.systemProperties) {
            this.systemProperties = new Properties();
        }
        if (key != null && value != null) {
            this.systemProperties.put(key, value);
        }
    }

    public Message(String topic, String tags, byte[] body) {
        this(topic, tags, "", body);
    }

    public void putUserProperties(String key, String value) {
        if (null == this.userProperties) {
            this.userProperties = new Properties();
        }
        if (key != null && value != null) {
            this.userProperties.put(key, value);
        }
    }

    public String getUserProperties(String key) {
        if (null != this.userProperties) {
            return (String)this.userProperties.get(key);
        }
        return null;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTag() {
        return this.getSystemProperties("__TAG");
    }

    public String getSystemProperties(String key) {
        if (null != this.systemProperties) {
            return this.systemProperties.getProperty(key);
        }
        return null;
    }

    public void setTag(String tag) {
        this.putSystemProperties("__TAG", tag);
    }

    public String getKey() {
        return this.getSystemProperties("__KEY");
    }

    public void setKey(String key) {
        this.putSystemProperties("__KEY", key);
    }

    public String getMsgID() {
        return this.getSystemProperties("__MSGID");
    }

    public void setMsgID(String msgid) {
        this.putSystemProperties("__MSGID", msgid);
    }

    public Properties getSystemProperties() {
        if (null == this.systemProperties) {
            return new Properties();
        }
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Properties getUserProperties() {
        if (null == this.userProperties) {
            return new Properties();
        }
        return this.userProperties;
    }

    public void setUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public int getReconsumeTimes() {
        String pro = this.getSystemProperties("__RECONSUMETIMES");
        if (pro != null) {
            return Integer.parseInt(pro);
        }
        return 0;
    }

    public void setReconsumeTimes(int value) {
        this.putSystemProperties("__RECONSUMETIMES", String.valueOf(value));
    }

    public long getBornTimestamp() {
        String pro = this.getSystemProperties("__BORNTIMESTAMP");
        if (pro != null) {
            return Long.parseLong(pro);
        }
        return 0L;
    }

    public void setBornTimestamp(long value) {
        this.putSystemProperties("__BORNTIMESTAMP", String.valueOf(value));
    }

    public String getBornHost() {
        String pro = this.getSystemProperties("__BORNHOST");
        return pro == null ? "" : pro;
    }

    public void setBornHost(String value) {
        this.putSystemProperties("__BORNHOST", value);
    }

    public long getStartDeliverTime() {
        String pro = this.getSystemProperties("__STARTDELIVERTIME");
        if (pro != null) {
            return Long.parseLong(pro);
        }
        return 0L;
    }

    public String getShardingKey() {
        String pro = this.getSystemProperties("__SHARDINGKEY");
        return pro == null ? "" : pro;
    }

    public void setShardingKey(String value) {
        this.putSystemProperties("__SHARDINGKEY", value);
    }

    public void setStartDeliverTime(long value) {
        this.putSystemProperties("__STARTDELIVERTIME", String.valueOf(value));
    }

    public long getOffset() {
        String v = this.getSystemProperties("__CONSUMEOFFSET");
        if (v != null) {
            return Long.parseLong(v);
        }
        return 0L;
    }

    public TopicPartition getTopicPartition() {
        return new TopicPartition(this.topic, this.getSystemProperties("__PARTITION"));
    }

    public String toString() {
        return "Message [topic=" + this.topic + ", systemProperties=" + this.systemProperties + ", userProperties=" + this.userProperties + ", body=" + (this.body != null ? this.body.length : 0) + "]";
    }

    public static class SystemPropKey {
        public static final String TAG = "__TAG";
        public static final String KEY = "__KEY";
        public static final String MSGID = "__MSGID";
        public static final String SHARDINGKEY = "__SHARDINGKEY";
        public static final String RECONSUMETIMES = "__RECONSUMETIMES";
        public static final String BORNTIMESTAMP = "__BORNTIMESTAMP";
        public static final String BORNHOST = "__BORNHOST";
        public static final String STARTDELIVERTIME = "__STARTDELIVERTIME";
        public static final String CONSUMEOFFSET = "__CONSUMEOFFSET";
        public static final String PARTITION = "__PARTITION";
    }
}

