/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;

public final class ProtocolPluginFactory {
    private static final Map<String, ProtocolAdaptor<ProtocolTransportObject>> PROTOCOL_ADAPTOR_MAP = new ConcurrentHashMap<String, ProtocolAdaptor<ProtocolTransportObject>>(16);

    public static ProtocolAdaptor<ProtocolTransportObject> getProtocolAdaptor(String protocolType) {
        ProtocolAdaptor protocolAdaptor = PROTOCOL_ADAPTOR_MAP.computeIfAbsent(protocolType, type -> (ProtocolAdaptor)EventMeshExtensionFactory.getExtension(ProtocolAdaptor.class, (String)type));
        if (protocolAdaptor == null) {
            throw new IllegalArgumentException(String.format("Cannot find the Protocol adaptor: %s", protocolType));
        }
        return protocolAdaptor;
    }

    private ProtocolPluginFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

