/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.consumer;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.eventmesh.storage.rocketmq.cloudevent.RocketMQMessageFactory;
import org.apache.eventmesh.storage.rocketmq.config.ClientConfig;
import org.apache.eventmesh.storage.rocketmq.patch.EventMeshConsumeConcurrentlyContext;
import org.apache.eventmesh.storage.rocketmq.patch.EventMeshConsumeConcurrentlyStatus;
import org.apache.eventmesh.storage.rocketmq.patch.EventMeshMessageListenerConcurrently;
import org.apache.eventmesh.storage.rocketmq.utils.BeanUtils;
import org.apache.eventmesh.storage.rocketmq.utils.CloudEventUtils;
import org.apache.eventmesh.storage.rocketmq.utils.OMSUtil;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageConcurrentlyService;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageService;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.LanguageCode;

public class PushConsumerImpl {
    private final DefaultMQPushConsumer rocketmqPushConsumer;
    private final Properties properties;
    private AtomicBoolean started = new AtomicBoolean(false);
    private EventListener eventListener;
    private final ClientConfig clientConfig;

    public PushConsumerImpl(Properties properties) {
        this.rocketmqPushConsumer = new DefaultMQPushConsumer();
        this.properties = properties;
        this.clientConfig = (ClientConfig)((Object)BeanUtils.populate(properties, ClientConfig.class));
        String accessPoints = this.clientConfig.getAccessPoints();
        if (accessPoints == null || accessPoints.isEmpty()) {
            throw new StorageRuntimeException("OMS AccessPoints is null or empty.");
        }
        this.rocketmqPushConsumer.setNamesrvAddr(accessPoints.replace(',', ';'));
        String consumerGroup = this.clientConfig.getConsumerId();
        if (null == consumerGroup || consumerGroup.isEmpty()) {
            throw new StorageRuntimeException("Consumer Group is necessary for RocketMQ, please set it.");
        }
        this.rocketmqPushConsumer.setConsumerGroup(consumerGroup);
        this.rocketmqPushConsumer.setMaxReconsumeTimes(this.clientConfig.getRmqMaxRedeliveryTimes());
        this.rocketmqPushConsumer.setConsumeTimeout((long)this.clientConfig.getRmqMessageConsumeTimeout());
        this.rocketmqPushConsumer.setConsumeThreadMax(this.clientConfig.getRmqMaxConsumeThreadNums());
        this.rocketmqPushConsumer.setConsumeThreadMin(this.clientConfig.getRmqMinConsumeThreadNums());
        this.rocketmqPushConsumer.setMessageModel(MessageModel.valueOf((String)this.clientConfig.getMessageModel()));
        String consumerId = OMSUtil.buildInstanceName();
        this.rocketmqPushConsumer.setInstanceName(properties.getProperty("instanceName"));
        properties.put("CONSUMER_ID", consumerId);
        this.rocketmqPushConsumer.setLanguage(LanguageCode.OMS);
        if (this.clientConfig.getMessageModel().equalsIgnoreCase(MessageModel.BROADCASTING.name())) {
            this.rocketmqPushConsumer.registerMessageListener((MessageListenerConcurrently)new BroadCastingMessageListener());
        } else {
            this.rocketmqPushConsumer.registerMessageListener((MessageListenerConcurrently)new ClusteringMessageListener());
        }
    }

    public Properties attributes() {
        return this.properties;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.rocketmqPushConsumer.start();
            }
            catch (Exception e) {
                throw new StorageRuntimeException(e.getMessage());
            }
        }
    }

    public synchronized void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.rocketmqPushConsumer.shutdown();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public DefaultMQPushConsumer getRocketmqPushConsumer() {
        return this.rocketmqPushConsumer;
    }

    public void subscribe(String topic, String subExpression) {
        try {
            this.rocketmqPushConsumer.subscribe(topic, subExpression);
        }
        catch (MQClientException e) {
            throw new StorageRuntimeException(String.format("RocketMQ push consumer can't attach to %s.", topic));
        }
    }

    public void unsubscribe(String topic) {
        try {
            this.rocketmqPushConsumer.unsubscribe(topic);
        }
        catch (Exception e) {
            throw new StorageRuntimeException(String.format("RocketMQ push consumer fails to unsubscribe topic: %s", topic));
        }
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        ConsumeMessageService consumeMessageService = this.rocketmqPushConsumer.getDefaultMQPushConsumerImpl().getConsumeMessageService();
        ArrayList<MessageExt> msgExtList = new ArrayList<MessageExt>(cloudEvents.size());
        for (CloudEvent msg : cloudEvents) {
            if (msg == null) continue;
            msgExtList.add(CloudEventUtils.msgConvertExt((Message)RocketMQMessageFactory.createWriter(Objects.requireNonNull(msg.getSubject())).writeBinary(msg)));
        }
        ((ConsumeMessageConcurrentlyService)consumeMessageService).updateOffset(msgExtList, (EventMeshConsumeConcurrentlyContext)context);
    }

    public void registerEventListener(EventListener listener) {
        this.eventListener = listener;
    }

    private class ClusteringMessageListener
    extends EventMeshMessageListenerConcurrently {
        private ClusteringMessageListener() {
        }

        @Override
        public EventMeshConsumeConcurrentlyStatus handleMessage(MessageExt msg, EventMeshConsumeConcurrentlyContext context) {
            if (msg == null) {
                return EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
            msg.putUserProperty("borntimestamp", String.valueOf(msg.getBornTimestamp()));
            msg.putUserProperty("storetime", String.valueOf(msg.getStoreTimestamp()));
            CloudEvent cloudEvent = RocketMQMessageFactory.createReader(CloudEventUtils.msgConvert(msg)).toEvent();
            CloudEventBuilder cloudEventBuilder = null;
            for (String sysPropKey : MessageConst.STRING_HASH_SET) {
                if (!StringUtils.isNotEmpty((CharSequence)msg.getProperty(sysPropKey))) continue;
                String prop = msg.getProperty(sysPropKey);
                sysPropKey = sysPropKey.toLowerCase().replace("_", "99");
                cloudEventBuilder = CloudEventBuilder.from((CloudEvent)cloudEvent).withExtension(sysPropKey, prop);
            }
            if (cloudEventBuilder != null) {
                cloudEvent = cloudEventBuilder.build();
            }
            if (PushConsumerImpl.this.eventListener == null) {
                throw new StorageRuntimeException(String.format("The topic/queue %s isn't attached to this consumer", msg.getTopic()));
            }
            final Properties contextProperties = new Properties();
            contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
            EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = new EventMeshAsyncConsumeContext(){

                public void commit(EventMeshAction action) {
                    switch (action) {
                        case CommitMessage: {
                            contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS.name());
                            break;
                        }
                        case ReconsumeLater: {
                            contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
                            break;
                        }
                        case ManualAck: {
                            contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_FINISH.name());
                            break;
                        }
                    }
                }
            };
            eventMeshAsyncConsumeContext.setAbstractContext((AbstractContext)context);
            PushConsumerImpl.this.eventListener.consume(cloudEvent, (AsyncConsumeContext)eventMeshAsyncConsumeContext);
            return EventMeshConsumeConcurrentlyStatus.valueOf(contextProperties.getProperty("rmq.message.consume.status"));
        }
    }

    private class BroadCastingMessageListener
    extends EventMeshMessageListenerConcurrently {
        private BroadCastingMessageListener() {
        }

        @Override
        public EventMeshConsumeConcurrentlyStatus handleMessage(MessageExt msg, EventMeshConsumeConcurrentlyContext context) {
            if (msg == null) {
                return EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
            msg.putUserProperty("borntimestamp", String.valueOf(msg.getBornTimestamp()));
            msg.putUserProperty("storetimestamp", String.valueOf(msg.getStoreTimestamp()));
            CloudEvent cloudEvent = RocketMQMessageFactory.createReader(CloudEventUtils.msgConvert(msg)).toEvent();
            CloudEventBuilder cloudEventBuilder = null;
            for (String sysPropKey : MessageConst.STRING_HASH_SET) {
                if (!StringUtils.isNotEmpty((CharSequence)msg.getProperty(sysPropKey))) continue;
                String prop = msg.getProperty(sysPropKey);
                sysPropKey = sysPropKey.toLowerCase().replace("_", "99");
                cloudEventBuilder = CloudEventBuilder.from((CloudEvent)cloudEvent).withExtension(sysPropKey, prop);
            }
            if (cloudEventBuilder != null) {
                cloudEvent = cloudEventBuilder.build();
            }
            if (PushConsumerImpl.this.eventListener == null) {
                throw new StorageRuntimeException(String.format("The topic/queue %s isn't attached to this consumer", msg.getTopic()));
            }
            final Properties contextProperties = new Properties();
            contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
            EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = new EventMeshAsyncConsumeContext(){

                public void commit(EventMeshAction action) {
                    switch (action) {
                        case CommitMessage: {
                            contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS.name());
                            break;
                        }
                        case ReconsumeLater: {
                            contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
                            break;
                        }
                        case ManualAck: {
                            contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_FINISH.name());
                            break;
                        }
                    }
                }
            };
            eventMeshAsyncConsumeContext.setAbstractContext((AbstractContext)context);
            PushConsumerImpl.this.eventListener.consume(cloudEvent, (AsyncConsumeContext)eventMeshAsyncConsumeContext);
            return EventMeshConsumeConcurrentlyStatus.valueOf(contextProperties.getProperty("rmq.message.consume.status"));
        }
    }
}

