/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.util;

import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.common.Constants;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String post(CloseableHttpClient client, String uri, RequestParam requestParam) throws IOException {
        return HttpUtils.post(client, null, uri, requestParam);
    }

    public static String post(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam) throws IOException {
        return HttpUtils.post(client, forwardAgent, uri, requestParam, new EventMeshResponseHandler());
    }

    public static String post(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam, ResponseHandler<String> responseHandler) throws IOException {
        Preconditions.checkState((client != null ? 1 : 0) != 0, (Object)"client can't be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"uri can't be null");
        Preconditions.checkState((requestParam != null ? 1 : 0) != 0, (Object)"requestParam can't be null");
        Preconditions.checkState((responseHandler != null ? 1 : 0) != 0, (Object)"responseHandler can't be null");
        Preconditions.checkState((boolean)requestParam.getHttpMethod().equals((Object)HttpMethod.POST), (Object)"invalid requestParam httpMethod");
        HttpPost httpPost = new HttpPost(uri);
        if (MapUtils.isNotEmpty(requestParam.getHeaders())) {
            for (Map.Entry<String, String> entry : requestParam.getHeaders().entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(requestParam.getBody())) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : requestParam.getBody().entrySet()) {
                pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Constants.DEFAULT_CHARSET));
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout())));
        if (forwardAgent != null) {
            configBuilder.setProxy(forwardAgent);
        }
        httpPost.setConfig(configBuilder.build());
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)httpPost);
        }
        return (String)client.execute((HttpUriRequest)httpPost, responseHandler);
    }

    public static String get(CloseableHttpClient client, String url, RequestParam requestParam) throws IOException {
        return HttpUtils.get(client, null, url, requestParam, new EventMeshResponseHandler());
    }

    public static String get(CloseableHttpClient client, HttpHost forwardAgent, String url, RequestParam requestParam) throws IOException {
        return HttpUtils.get(client, forwardAgent, url, requestParam, new EventMeshResponseHandler());
    }

    public static String get(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam, ResponseHandler<String> responseHandler) throws IOException {
        Preconditions.checkState((client != null ? 1 : 0) != 0, (Object)"client can't be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"uri can't be null");
        Preconditions.checkState((requestParam != null ? 1 : 0) != 0, (Object)"requestParam can't be null");
        Preconditions.checkState((boolean)requestParam.getHttpMethod().equals((Object)HttpMethod.GET), (Object)"invalid requestParam httpMethod");
        HttpGet httpGet = new HttpGet(MapUtils.isNotEmpty(requestParam.getQueryParamsMap()) ? uri + "?" + requestParam.getQueryParams() : uri);
        if (MapUtils.isNotEmpty(requestParam.getHeaders())) {
            for (Map.Entry<String, String> entry : requestParam.getHeaders().entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout())));
        if (forwardAgent != null) {
            configBuilder.setProxy(forwardAgent);
        }
        httpGet.setConfig(configBuilder.build());
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)httpGet);
        }
        return (String)client.execute((HttpUriRequest)httpGet, responseHandler);
    }

    private static class EventMeshResponseHandler
    implements ResponseHandler<String> {
        private EventMeshResponseHandler() {
        }

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                HttpEntity entity = response.getEntity();
                return entity != null ? EntityUtils.toString((HttpEntity)entity, (Charset)Constants.DEFAULT_CHARSET) : null;
            }
            throw new ClientProtocolException("Unexpected response statusCode: " + statusCode);
        }
    }
}

