/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server.lifecycle;

import com.navercorp.pinpoint.grpc.Header;
import com.navercorp.pinpoint.grpc.server.ServerContext;
import com.navercorp.pinpoint.grpc.server.TransportMetadata;
import com.navercorp.pinpoint.grpc.server.lifecycle.LifecycleListener;
import com.navercorp.pinpoint.grpc.server.lifecycle.PingEventHandler;
import com.navercorp.pinpoint.grpc.server.lifecycle.PingSession;
import com.navercorp.pinpoint.grpc.server.lifecycle.PingSessionRegistry;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultPingEventHandler
implements PingEventHandler {
    private static final long PING_MIN_TIME_MILLIS = 60000L;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final PingSessionRegistry pingSessionRegistry;
    private final LifecycleListener lifecycleListener;

    public DefaultPingEventHandler(PingSessionRegistry pingSessionRegistry, LifecycleListener lifecycleListener) {
        this.pingSessionRegistry = Objects.requireNonNull(pingSessionRegistry, "pingSessionRegistry");
        this.lifecycleListener = Objects.requireNonNull(lifecycleListener, "lifecycleListener");
    }

    @Override
    public void connect() {
        TransportMetadata transportMetadata = ServerContext.getTransportMetadata();
        if (transportMetadata == null) {
            this.logger.info("Skip connect event handle of ping, not found TransportMetadata. header={}", (Object)ServerContext.getAgentInfo());
            return;
        }
        Long transportId = transportMetadata.getTransportId();
        Header header = ServerContext.getAgentInfo();
        PingSession pingSession = new PingSession(transportId, header);
        pingSession.setLastPingTimeMillis(System.currentTimeMillis());
        PingSession oldSession = this.pingSessionRegistry.add(pingSession.getId(), pingSession);
        if (oldSession != null) {
            this.logger.warn("Duplicated ping session old={}, new={}", (Object)oldSession, (Object)pingSession);
        }
        this.lifecycleListener.connect(pingSession);
    }

    @Override
    public void ping() {
        TransportMetadata transportMetadata = ServerContext.getTransportMetadata();
        if (transportMetadata == null) {
            this.logger.info("Skip ping event handle of ping, not found TransportMetadata. header={}", (Object)ServerContext.getAgentInfo());
            return;
        }
        PingSession pingSession = this.pingSessionRegistry.get(transportMetadata.getTransportId());
        if (pingSession == null) {
            this.logger.info("Skip ping event handle of ping, not found ping session. transportMetadata={}", (Object)transportMetadata);
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (60000L < currentTimeMillis - pingSession.getLastPingTimeMillis()) {
            return;
        }
        pingSession.setLastPingTimeMillis(currentTimeMillis);
        this.lifecycleListener.handshake(pingSession);
    }

    @Override
    public void close() {
        TransportMetadata transportMetadata = ServerContext.getTransportMetadata();
        if (transportMetadata == null) {
            this.logger.info("Skip close event handle of ping, not found TransportMetadata. header={}", (Object)ServerContext.getAgentInfo());
            return;
        }
        PingSession removedSession = this.pingSessionRegistry.remove(transportMetadata.getTransportId());
        if (removedSession == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Remove ping session. pingSession={}", (Object)removedSession);
        }
        this.lifecycleListener.close(removedSession);
    }

    @Override
    public void update(short serviceType) {
        TransportMetadata transportMetadata = ServerContext.getTransportMetadata();
        if (transportMetadata == null) {
            this.logger.info("Skip update event handle of ping, not found TransportMetadata. header={}", (Object)ServerContext.getAgentInfo());
            return;
        }
        PingSession pingSession = this.pingSessionRegistry.get(transportMetadata.getTransportId());
        if (pingSession == null) {
            this.logger.info("Skip update event handle of ping, not found ping session. transportMetadata={}", (Object)transportMetadata);
            return;
        }
        pingSession.setServiceType(serviceType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Update ping session. PingSession={}", (Object)pingSession);
        }
        if (!pingSession.isUpdated()) {
            this.lifecycleListener.connect(pingSession);
            pingSession.setUpdated(true);
        }
    }
}

