/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client.interceptor;

import com.navercorp.pinpoint.grpc.client.interceptor.DiscardClientCall;
import com.navercorp.pinpoint.grpc.client.interceptor.DiscardEventListener;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiscardClientInterceptor
implements ClientInterceptor {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final DiscardEventListener listener;
    private final long maxPendingThreshold;
    private final long discardCountForReconnect;
    private final long notReadyTimeoutMillis;

    public DiscardClientInterceptor(DiscardEventListener listener, long maxPendingThreshold, long discardCountForReconnect, long notReadyTimeoutMillis) {
        this.listener = Objects.requireNonNull(listener, "listener");
        this.maxPendingThreshold = maxPendingThreshold;
        this.discardCountForReconnect = discardCountForReconnect;
        this.notReadyTimeoutMillis = notReadyTimeoutMillis;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (MethodDescriptor.MethodType.CLIENT_STREAMING == method.getType()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("interceptCall {}", (Object)method.getFullMethodName());
            }
            ClientCall newCall = next.newCall(method, callOptions);
            return new DiscardClientCall(newCall, this.listener, this.maxPendingThreshold, this.discardCountForReconnect, this.notReadyTimeoutMillis);
        }
        return next.newCall(method, callOptions);
    }
}

