/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;

public final class MessageFormatUtils {
    private static final String NULL_STR = "null";
    private static final LogMessage NULL_LOG = new NullLogMessage();

    private MessageFormatUtils() {
    }

    public static LogMessage debugLog(GeneratedMessageV3 message) {
        if (message == null) {
            return NULL_LOG;
        }
        return new LazyLogMessage(message);
    }

    private static class NullLogMessage
    implements LogMessage {
        private NullLogMessage() {
        }

        public String toString() {
            return MessageFormatUtils.NULL_STR;
        }
    }

    private static class LazyLogMessage
    implements LogMessage {
        private final GeneratedMessageV3 message;

        private LazyLogMessage(GeneratedMessageV3 message) {
            this.message = message;
        }

        public String toString() {
            return TextFormat.shortDebugString((MessageOrBuilder)this.message);
        }
    }

    public static interface LogMessage {
    }
}

