/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config.convert.converter;

import com.google.common.base.Splitter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.eventmesh.common.config.convert.ConvertInfo;
import org.apache.eventmesh.common.config.convert.ConvertValue;
import org.apache.eventmesh.common.config.convert.ConverterMap;

public class ListConverter
implements ConvertValue<List<Object>> {
    public String separator = ",";

    @Override
    public boolean canHandleNullValue() {
        return true;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public List<Object> convert(ConvertInfo convertInfo) {
        return this.convert(convertInfo, this.getSeparator());
    }

    public List<Object> convert(ConvertInfo convertInfo, String separator) {
        try {
            if (convertInfo.getValue() == null) {
                return new ArrayList<Object>();
            }
            List list = Objects.equals(convertInfo.getField().getType(), List.class) ? new ArrayList() : (List)convertInfo.getField().getType().newInstance();
            Type parameterizedType = ((ParameterizedType)convertInfo.getField().getGenericType()).getActualTypeArguments()[0];
            ConvertValue<?> clazzConverter = ConverterMap.getClazzConverter((Class)parameterizedType);
            List values = Splitter.on((String)separator).omitEmptyStrings().trimResults().splitToList((CharSequence)((String)convertInfo.getValue()));
            for (String value : values) {
                convertInfo.setValue(value);
                list.add(clazzConverter.convert(convertInfo));
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ListConverterSemi
    extends ListConverter {
        public String separator = ";";

        @Override
        public String getSeparator() {
            return this.separator;
        }

        @Override
        public List<Object> convert(ConvertInfo convertInfo) {
            return super.convert(convertInfo, this.getSeparator());
        }
    }
}

