// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef __RMB_VECTOR_H_
#define __RMB_VECTOR_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include "rmb_define.h"

#define MAX_SIZE_PER_TIME 1024

  void Init (Array * this);
  void _constructor (Array * this);
  void _destructor (Array * this);
  void _input (DataType data, Array * this);
  int _get_size (Array * this);
  DataType _return_index_value (Array * this, int index);

#ifdef __cplusplus
}
#endif

#endif
