/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Entity;
import org.apache.empire.data.bean.BeanDomain;
import org.apache.empire.data.bean.BeanProperty;

public abstract class BeanClass
implements Entity {
    private final String name;
    private final List<BeanProperty> properties = new ArrayList<BeanProperty>();
    private Column[] keyColumns;
    protected BeanDomain domain;

    protected BeanClass(String name) {
        this.name = name;
    }

    protected BeanClass(String name, BeanDomain dom) {
        this(name);
        dom.addClass(this);
    }

    protected void addProp(BeanProperty prop) {
        this.properties.add(prop);
        prop.beanClass = this;
    }

    protected BeanProperty addProp(String propname, DataType dataType, double size, boolean required, String controlType, boolean readOnly) {
        BeanProperty prop = new BeanProperty(propname, dataType, size, required, controlType, readOnly);
        this.addProp(prop);
        return prop;
    }

    protected final BeanProperty addProp(String propname, DataType dataType, double size, boolean required, String controlType) {
        return this.addProp(propname, dataType, size, required, controlType, false);
    }

    protected final BeanProperty addProp(String propname, DataType dataType, double size, boolean required, boolean readOnly) {
        return this.addProp(propname, dataType, size, required, "text", readOnly);
    }

    protected final BeanProperty addProp(String propname, DataType dataType, double size, boolean required) {
        return this.addProp(propname, dataType, size, required, "text", false);
    }

    protected void setKeyColumns(Column[] keyColumns) {
        this.keyColumns = keyColumns;
    }

    protected final void setKeyColumn(Column keyColumn) {
        this.setKeyColumns(new Column[]{keyColumn});
    }

    @Override
    public String getEntityName() {
        return this.name;
    }

    public List<BeanProperty> getColumns() {
        return Collections.unmodifiableList(this.properties);
    }

    @Override
    public Column[] getKeyColumns() {
        return this.keyColumns;
    }

    public List<BeanProperty> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public BeanDomain getDomain() {
        return this.domain;
    }
}

