/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanPropertyUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);
    private static BeanPropertyUtilsImpl instance = new BeanPropertyUtilsImpl();

    public static BeanPropertyUtilsImpl getImplementation() {
        return instance;
    }

    public static void setImplementation(BeanPropertyUtilsImpl utils) {
        instance = utils;
    }

    public static int hasProperty(Object bean, String property, boolean writeAccess) {
        return instance.hasProperty(bean, property, writeAccess);
    }

    public static Object getProperty(Object bean, String property) {
        return instance.getProperty(bean, property);
    }

    public static boolean setProperty(Object bean, String property, Object value) {
        return instance.setProperty(bean, property, value);
    }

    public static Object convertPropertyValue(Object value, Class<?> type) {
        return instance.convertPropertyValue(value, type);
    }

    public static class BeanPropertyUtilsImpl {
        public int hasProperty(Object bean, String property, boolean writeAccess) {
            if (bean == null) {
                throw new InvalidArgumentException("bean", bean);
            }
            if (property == null) {
                throw new InvalidArgumentException("property", property);
            }
            try {
                PropertyUtilsBean propUtils = BeanUtilsBean.getInstance().getPropertyUtils();
                PropertyDescriptor pd = propUtils.getPropertyDescriptor(bean, property);
                if (pd == null) {
                    return -1;
                }
                Method method = writeAccess ? propUtils.getWriteMethod(pd) : propUtils.getReadMethod(pd);
                return method != null ? 1 : 0;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                log.warn("Property access failed for {} on {}: {}", new Object[]{property, bean.getClass().getName(), cause.getMessage()});
                return 0;
            }
        }

        public Object getProperty(Object bean, String property) {
            if (bean == null) {
                throw new InvalidArgumentException("bean", bean);
            }
            if (property == null) {
                throw new InvalidArgumentException("property", property);
            }
            try {
                PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
                return pub.getSimpleProperty(bean, property);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
                throw new BeanPropertyGetException(bean, property, e);
            }
        }

        public boolean setProperty(Object bean, String property, Object value) {
            try {
                PropertyUtilsBean propUtils;
                PropertyDescriptor pd;
                if (bean == null) {
                    throw new InvalidArgumentException("bean", bean);
                }
                if (StringUtils.isEmpty(property)) {
                    throw new InvalidArgumentException("property", property);
                }
                if (log.isTraceEnabled()) {
                    log.trace("{}: setting property '{}' to {}", new Object[]{bean.getClass().getName(), property, value});
                }
                if ((pd = (propUtils = BeanUtilsBean.getInstance().getPropertyUtils()).getPropertyDescriptor(bean, property)) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("{}:  property '{}' does not exist!", (Object)bean.getClass().getName(), (Object)property);
                    }
                    return false;
                }
                Method method = propUtils.getWriteMethod(bean.getClass(), pd);
                if (method == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("{}:  property '{}' has no write method!", (Object)bean.getClass().getName(), (Object)property);
                    }
                    return false;
                }
                Class<?> propType = pd.getPropertyType();
                value = this.convertPropertyValue(value, propType);
                if (propType.isArray()) {
                    method.invoke(bean, value);
                } else {
                    method.invoke(bean, value);
                }
                return true;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
                throw new BeanPropertySetException(bean, property, e);
            }
            catch (NullPointerException e) {
                log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
                throw new BeanPropertySetException(bean, property, e);
            }
        }

        public Object convertPropertyValue(Object value, Class<?> type) {
            ConvertUtilsBean convertUtils = BeanUtilsBean.getInstance().getConvertUtils();
            if (type.isArray()) {
                if (value == null) {
                    String[] values = new String[]{};
                    return convertUtils.convert(values, type);
                }
                if (value instanceof String) {
                    return convertUtils.convert(value, type);
                }
                if (value instanceof String[]) {
                    return convertUtils.convert((String[])value, type);
                }
                return convertUtils.convert(value, type);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return convertUtils.convert((String)value, type);
            }
            if (value instanceof String[]) {
                return convertUtils.convert(((String[])value)[0], type);
            }
            return convertUtils.convert(value, type);
        }
    }
}

