/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.empire.commons.BeanPropertyUtils;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageDefinitions;
import org.apache.empire.jsf2.pages.PageNavigationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PagePhaseListener.class);
    private static final String LAST_PAGE_VIEW_ID = "lastPageViewId";
    public static final String FORWARD_PAGE_PARAMS = "forwardPageParams";

    public PagePhaseListener() {
        log.trace("PagePhaseListener created.");
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent pe) {
        PageDefinition pageDef;
        FacesContext fc;
        UIViewRoot vr;
        PhaseId phaseId = pe.getPhaseId();
        if (log.isTraceEnabled()) {
            log.trace("Processing Phase {}.", (Object)phaseId);
        }
        if ((vr = (fc = pe.getFacesContext()).getViewRoot()) == null) {
            return;
        }
        String viewId = vr.getViewId();
        if (viewId == null) {
            if (phaseId == PhaseId.RENDER_RESPONSE) {
                FacesUtils.getWebApplication().onViewNotFound(fc, FacesUtils.getHttpRequest(fc));
            } else {
                log.error("No viewId provided for PagePhaseEvent in phase " + phaseId.getName());
            }
            return;
        }
        Map sessionMap = fc.getExternalContext().getSessionMap();
        Object lastViewId = sessionMap.get(LAST_PAGE_VIEW_ID);
        if (lastViewId == null || !((String)lastViewId).equalsIgnoreCase(viewId)) {
            FacesUtils.getWebApplication().onChangeView(fc, viewId);
            if (fc.getResponseComplete()) {
                return;
            }
            sessionMap.put(LAST_PAGE_VIEW_ID, viewId);
        }
        if ((pageDef = PageDefinitions.getInstance().getPageFromViewId(viewId)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("No page definition available for viewId {}.", (Object)viewId);
            }
            return;
        }
        String name = pageDef.getPageBeanName();
        Map viewMap = vr.getViewMap();
        Page pageBean = (Page)viewMap.get(name);
        if (pageBean == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating page bean of type {} for {} in Phase {}.", new Object[]{pageDef.getPageBeanClass().getName(), viewId, pe.getPhaseId()});
            }
            pageBean = this.createPageBean(name, pageDef, fc);
            viewMap.put(name, pageBean);
            pageBean.setPageDefinition(pageDef);
            viewMap.put("page", pageBean);
        }
        if (pe.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.initPageBean(pageBean, fc, viewMap);
        }
    }

    protected Page createPageBean(String name, PageDefinition pageDef, FacesContext fc) {
        Class<? extends Page> pageClass = pageDef.getPageBeanClass();
        Page pageBean = (Page)FacesUtils.getManagedBean(fc, name);
        if (pageBean == null) {
            log.warn("Unable to obtain page bean \"{}\" from BeanManager. Page bean probably not registered. Creating new instance but Injection might not work! ", (Object)name);
            try {
                pageBean = pageClass.newInstance();
            }
            catch (Exception e) {
                log.error("Error creating instance of page bean " + pageClass.getName(), (Throwable)e);
                throw new InternalException((Throwable)e);
            }
        } else if (!pageClass.isInstance(pageBean)) {
            log.warn("Page bean \"{}\" is not an instance of class {} as expected. Detected class is {}", new Object[]{name, pageClass.getName(), pageBean.getClass().getName()});
        }
        return pageBean;
    }

    protected void initPageBean(Page pageBean, FacesContext fc, Map<String, Object> viewMap) {
        if (!pageBean.isInitialized()) {
            if (!PageNavigationHandler.isInitialized()) {
                log.error("PageNavigationHandler has not been initialized. Forward operations will not work!");
            }
            if (viewMap.containsKey(FORWARD_PAGE_PARAMS)) {
                Map pageParams = (Map)viewMap.remove(FORWARD_PAGE_PARAMS);
                this.setPageParams(pageBean, pageParams);
            }
        }
        pageBean.preRenderPage(fc);
    }

    protected void setPageParams(Page pageBean, Map<String, String> pageParams) {
        for (String name : pageParams.keySet()) {
            String value = pageParams.get(name);
            try {
                if (BeanPropertyUtils.setProperty((Object)pageBean, (String)name, (Object)value)) continue;
                log.error("Unable to set PageParam \"{}\" on {}", (Object)name, (Object)pageBean.getClass().getName());
            }
            catch (Exception e) {
                log.error("Unable to set PageParam \"{}\" on {}", new Object[]{name, pageBean.getClass().getName(), e});
            }
        }
    }

    public void afterPhase(PhaseEvent pe) {
        if (pe.getPhaseId() != PhaseId.RENDER_RESPONSE) {
            return;
        }
        UIViewRoot vr = pe.getFacesContext().getViewRoot();
        if (vr == null) {
            return;
        }
        Map viewMap = vr.getViewMap();
        Page pageBean = (Page)viewMap.get("page");
        if (pageBean != null && !pageBean.isInitialized()) {
            log.warn("PageBean was not initialized!");
            throw new ObjectNotValidException((Object)pageBean);
        }
        log.trace("PagePhase complete.");
    }
}

