/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.jsf2.controls.CheckboxInputControl;
import org.apache.empire.jsf2.controls.InputAttachedObjectsHandler;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.RadioInputControl;
import org.apache.empire.jsf2.controls.SelectInputControl;
import org.apache.empire.jsf2.controls.TextAreaInputControl;
import org.apache.empire.jsf2.controls.TextInputControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputControlManager {
    private static final Logger log = LoggerFactory.getLogger(InputControlManager.class);
    private static Class<? extends HtmlOutputLabel> labelComponentClass = HtmlOutputLabel.class;
    private static boolean showLabelRequiredMark = false;
    static HashMap<String, InputControl> controlMap = null;
    static InputAttachedObjectsHandler attachedObjectsHandler;
    static boolean inputValueExpressionEnabled;
    private static Map<Class<? extends UIComponent>, String> componentTypeMap;

    public static Class<? extends HtmlOutputLabel> getLabelComponentClass() {
        return labelComponentClass;
    }

    public static void setLabelComponentClass(Class<? extends HtmlOutputLabel> labelComponentClass) {
        InputControlManager.labelComponentClass = labelComponentClass;
    }

    public static boolean isShowLabelRequiredMark() {
        return showLabelRequiredMark;
    }

    public static void setShowLabelRequiredMark(boolean showLabelRequiredMark) {
        InputControlManager.showLabelRequiredMark = showLabelRequiredMark;
    }

    private InputControlManager() {
    }

    public static void registerControl(InputControl control) {
        controlMap.put(control.getName(), control);
    }

    public static InputControl getControl(String name) {
        return controlMap.get(name);
    }

    public static InputAttachedObjectsHandler getAttachedObjectsHandler() {
        return attachedObjectsHandler;
    }

    public static void setAttachedObjectsHandler(InputAttachedObjectsHandler attachedObjectsHandler) {
        InputControlManager.attachedObjectsHandler = attachedObjectsHandler;
    }

    public static boolean isInputValueExpressionEnabled() {
        return inputValueExpressionEnabled;
    }

    public static void setInputValueExpressionEnabled(boolean valueExpressionEnabled) {
        inputValueExpressionEnabled = valueExpressionEnabled;
    }

    public static <T extends UIComponent> T createComponent(FacesContext context, Class<T> clazz) {
        String type = componentTypeMap.get(clazz);
        if (type == null) {
            try {
                Field field = clazz.getDeclaredField("COMPONENT_TYPE");
                type = field != null ? StringUtils.toString((Object)field.get(null), (String)"") : "";
                log.debug("Component-Type for class {} is {}", (Object)clazz.getName(), (Object)type);
            }
            catch (SecurityException e) {
                throw new InternalException((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                log.debug("No Component-Type available for class {}!", (Object)clazz.getName());
                type = "";
            }
            catch (IllegalArgumentException e) {
                throw new InternalException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InternalException((Throwable)e);
            }
            componentTypeMap.put(clazz, type);
        }
        if (StringUtils.isEmpty((String)type)) {
            try {
                return (T)((UIComponent)clazz.newInstance());
            }
            catch (InstantiationException e) {
                throw new InternalException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return (T)context.getApplication().createComponent(type);
    }

    public static void registerComponentType(Class<? extends UIComponent> componentClass, String componentType) {
        if (componentClass == null) {
            throw new InvalidArgumentException("componentClass", componentClass);
        }
        if (StringUtils.isNotEmpty((String)componentType)) {
            log.debug("registering Component type {} for {}", (Object)componentType, (Object)componentClass.getName());
            componentTypeMap.put(componentClass, componentType);
        } else {
            log.debug("unregisterin Component type {} for {}", (Object)componentType, (Object)componentClass.getName());
            componentTypeMap.remove(componentClass);
        }
    }

    static {
        controlMap = new HashMap();
        InputControlManager.registerControl(new TextInputControl());
        InputControlManager.registerControl(new SelectInputControl());
        InputControlManager.registerControl(new TextAreaInputControl());
        InputControlManager.registerControl(new CheckboxInputControl());
        InputControlManager.registerControl(new RadioInputControl());
        attachedObjectsHandler = new InputAttachedObjectsHandler();
        inputValueExpressionEnabled = true;
        componentTypeMap = new HashMap<Class<? extends UIComponent>, String>();
    }
}

