// Copyright 2012 Google Inc.
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//
// All rights reserved.
//
// Additional constants from logging.h and its dependencies which are
// not exported by glog.

#ifndef _LOGGING_IN_H_
#define _LOGGING_IN_H_

// DFATAL is FATAL in debug mode, ERROR in normal mode
#ifdef NDEBUG
#define DFATAL_LEVEL ERROR
#else
#define DFATAL_LEVEL FATAL
#endif

// NDEBUG usage helpers related to (RAW_)DCHECK:
//
// GUTIL_DEBUG_MODE is for small !NDEBUG uses like
//   if (GUTIL_DEBUG_MODE) foo.CheckThatFoo();
// instead of substantially more verbose
//   #ifndef NDEBUG
//     foo.CheckThatFoo();
//   #endif
//
#ifdef NDEBUG
const bool GUTIL_DEBUG_MODE = false;
#else
const bool GUTIL_DEBUG_MODE = true;
#endif

#endif // _LOGGING_IN_H_
