/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.valueeditors;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.subtree.BaseSubtreeSpecification;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecificationParser;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.valueeditors.ExclusionDialog;
import org.apache.directory.studio.aciitemeditor.valueeditors.Messages;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.FilterWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

class SubtreeSpecificationDialog
extends Dialog {
    private final SubtreeSpecificationParser parser = new SubtreeSpecificationParser(null);
    private IBrowserConnection connection;
    private Dn subentryDn;
    private boolean refinementOrFilterVisible;
    private boolean useLocalName;
    private SubtreeSpecification subtreeSpecification;
    private List<String> exclusions;
    private String returnValue;
    private EntryWidget entryWidget;
    private Spinner minimumSpinner;
    private Spinner maximumSpinner;
    private TableViewer exclusionsTableViewer;
    private Button exclusionsTableEditButton;
    private Button exclusionsTableDeleteButton;
    private Button refinementButton;
    private Text refinementText;
    private Button filterButton;
    private FilterWidget filterWidget;

    SubtreeSpecificationDialog(Shell shell, IBrowserConnection connection, Dn subentryDn, String initialSubtreeSpecification, boolean refinementOrFilterVisible, boolean useLocalName) {
        super(shell);
        this.connection = connection;
        this.subentryDn = subentryDn;
        this.refinementOrFilterVisible = refinementOrFilterVisible;
        this.useLocalName = useLocalName;
        try {
            this.subtreeSpecification = this.parser.parse(initialSubtreeSpecification);
            if (this.subtreeSpecification == null) {
                this.subtreeSpecification = new BaseSubtreeSpecification();
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            this.subtreeSpecification = new BaseSubtreeSpecification();
        }
        this.exclusions = new ArrayList<String>();
        Set chopBeforeExclusions = this.subtreeSpecification.getChopBeforeExclusions();
        for (Dn dn : chopBeforeExclusions) {
            this.exclusions.add("chopBefore: \"" + dn.getNormName() + "\"");
        }
        Set chopAfterExclusions = this.subtreeSpecification.getChopAfterExclusions();
        for (Dn dn : chopAfterExclusions) {
            this.exclusions.add("chopAfter: \"" + dn.getNormName() + "\"");
        }
        this.returnValue = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SubtreeValueEditor.title"));
        newShell.setImage(Activator.getDefault().getImage(Messages.getString("SubtreeValueEditor.icon")));
    }

    protected void okPressed() {
        StringBuilder sb = new StringBuilder();
        this.subtreeSpecification.toString(sb);
        this.returnValue = sb.toString();
        if (this.refinementOrFilterVisible) {
            this.filterWidget.saveDialogSettings();
        }
        this.entryWidget.saveDialogSettings();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        outer.setLayoutData((Object)gd);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)outer, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SubtreeValueEditor.label.base"), (int)1);
        Dn base = this.subtreeSpecification.getBase();
        Dn suffix = null;
        if (this.subentryDn != null) {
            suffix = this.subentryDn.getParent();
        }
        this.entryWidget = new EntryWidget(this.connection, base, suffix, this.useLocalName);
        this.entryWidget.createWidget(composite);
        this.entryWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SubtreeSpecificationDialog.this.validate();
            }
        });
        GridData spinnersGridData = new GridData();
        spinnersGridData.grabExcessHorizontalSpace = true;
        spinnersGridData.verticalAlignment = 2;
        spinnersGridData.horizontalSpan = 2;
        spinnersGridData.horizontalAlignment = 1;
        spinnersGridData.widthHint = 36;
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SubtreeValueEditor.label.minimum"), (int)1);
        this.minimumSpinner = new Spinner(composite, 2048);
        this.minimumSpinner.setMinimum(0);
        this.minimumSpinner.setMaximum(Integer.MAX_VALUE);
        this.minimumSpinner.setDigits(0);
        this.minimumSpinner.setIncrement(1);
        this.minimumSpinner.setPageIncrement(100);
        this.minimumSpinner.setSelection(this.subtreeSpecification.getMinBaseDistance());
        this.minimumSpinner.setLayoutData((Object)spinnersGridData);
        this.minimumSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SubtreeSpecificationDialog.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SubtreeValueEditor.label.maximum"), (int)1);
        this.maximumSpinner = new Spinner(composite, 2048);
        this.maximumSpinner.setMinimum(0);
        this.maximumSpinner.setMaximum(Integer.MAX_VALUE);
        this.maximumSpinner.setDigits(0);
        this.maximumSpinner.setIncrement(1);
        this.maximumSpinner.setPageIncrement(100);
        this.maximumSpinner.setSelection(this.subtreeSpecification.getMaxBaseDistance());
        this.maximumSpinner.setLayoutData((Object)spinnersGridData);
        this.maximumSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SubtreeSpecificationDialog.this.validate();
            }
        });
        this.createExclusionsTable(composite);
        if (this.refinementOrFilterVisible) {
            BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
            this.createRefinementOrFilterWidgets(composite);
        }
        SubtreeSpecificationDialog.applyDialogFont((Control)outer);
        this.validate();
        return outer;
    }

    private void createExclusionsTable(Composite composite) {
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        tableGridData.heightHint = 100;
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SubtreeValueEditor.label.exclusions"), (int)1);
        Table exclusionsTable = new Table(composite, 2048);
        exclusionsTable.setHeaderVisible(false);
        exclusionsTable.setLayoutData((Object)tableGridData);
        exclusionsTable.setLinesVisible(false);
        this.exclusionsTableViewer = new TableViewer(exclusionsTable);
        this.exclusionsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.exclusionsTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.exclusionsTableViewer.setInput(this.exclusions);
        this.exclusionsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SubtreeSpecificationDialog.this.valueSelectedExclusionsTable();
            }
        });
        this.exclusionsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SubtreeSpecificationDialog.this.editValueExclusionsTable();
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)gridLayout);
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 4;
        buttonGridData.grabExcessHorizontalSpace = false;
        buttonGridData.verticalAlignment = 1;
        buttonGridData.widthHint = Activator.getButtonWidth((Control)buttonComposite);
        Button exclusionsTableAddButton = new Button(buttonComposite, 8);
        exclusionsTableAddButton.setText(Messages.getString("SubtreeValueEditor.button.add"));
        exclusionsTableAddButton.setLayoutData((Object)buttonGridData);
        exclusionsTableAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubtreeSpecificationDialog.this.addValueExclusionsTable();
            }
        });
        this.exclusionsTableEditButton = new Button(buttonComposite, 8);
        this.exclusionsTableEditButton.setText(Messages.getString("SubtreeValueEditor.button.edit"));
        this.exclusionsTableEditButton.setLayoutData((Object)buttonGridData);
        this.exclusionsTableEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubtreeSpecificationDialog.this.editValueExclusionsTable();
            }
        });
        this.exclusionsTableEditButton.setEnabled(false);
        this.exclusionsTableDeleteButton = new Button(buttonComposite, 8);
        this.exclusionsTableDeleteButton.setText(Messages.getString("SubtreeValueEditor.button.delete"));
        this.exclusionsTableDeleteButton.setLayoutData((Object)buttonGridData);
        this.exclusionsTableDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubtreeSpecificationDialog.this.deleteValueExclusionsTable();
            }
        });
        this.exclusionsTableDeleteButton.setEnabled(false);
    }

    private void createRefinementOrFilterWidgets(Composite parent) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("SubtreeValueEditor.SubtreeValueEditor.label.refinementOrFilter"), (int)1);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)2);
        this.refinementButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("SubtreeValueEditor.SubtreeValueEditor.label.refinement"), (int)2);
        this.refinementText = new Text(composite, 2818);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(50);
        this.refinementText.setLayoutData((Object)gd);
        try {
            StringBuilder refinementBuffer = new StringBuilder();
            if (this.subtreeSpecification.getRefinement() != null) {
                this.subtreeSpecification.getRefinement().printRefinementToBuffer(refinementBuffer);
            }
            this.refinementText.setText(refinementBuffer.toString().trim());
            this.refinementText.setEnabled(true);
            this.refinementButton.setSelection(true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.refinementText.setText("");
            this.refinementText.setEnabled(false);
            this.refinementButton.setSelection(false);
        }
        this.filterButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("SubtreeValueEditor.SubtreeValueEditor.label.filter"), (int)2);
        String filter = "";
        if (this.subtreeSpecification.getRefinement() != null) {
            filter = this.subtreeSpecification.getRefinement().toString();
        }
        this.filterWidget = new FilterWidget(filter);
        this.filterWidget.createWidget(composite);
        this.filterWidget.setBrowserConnection(this.connection);
        this.filterButton.setSelection(!this.refinementButton.getSelection());
        this.filterWidget.setEnabled(!this.refinementButton.getSelection());
        this.refinementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SubtreeSpecificationDialog.this.refinementText.setEnabled(true);
                SubtreeSpecificationDialog.this.filterWidget.setEnabled(false);
                SubtreeSpecificationDialog.this.validate();
            }
        });
        this.refinementText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SubtreeSpecificationDialog.this.validate();
            }
        });
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SubtreeSpecificationDialog.this.refinementText.setEnabled(false);
                SubtreeSpecificationDialog.this.filterWidget.setEnabled(true);
                SubtreeSpecificationDialog.this.validate();
            }
        });
        this.filterWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SubtreeSpecificationDialog.this.validate();
            }
        });
    }

    private void validate() {
        boolean valid = true;
        Dn base = this.entryWidget.getDn();
        valid &= base != null;
        String ss = this.buildSubreeSpecification();
        try {
            this.subtreeSpecification = this.parser.parse(ss);
            valid &= true;
        }
        catch (ParseException parseException) {
            this.subtreeSpecification = null;
            valid &= false;
        }
        if (this.refinementOrFilterVisible && this.filterButton.getSelection()) {
            valid &= this.filterWidget.getFilter() != null;
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(valid);
        }
    }

    private String buildSubreeSpecification() {
        int maximum;
        int minimum;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Dn base = this.entryWidget.getDn();
        if (base != null && !"".equals(base.toString())) {
            sb.append(" base \"");
            sb.append(base.toString());
            sb.append("\",");
        }
        if ((minimum = this.minimumSpinner.getSelection()) != 0) {
            sb.append(" minimum ").append(minimum).append(',');
        }
        if ((maximum = this.maximumSpinner.getSelection()) != 0) {
            sb.append(" maximum ").append(maximum).append(',');
        }
        if (!this.exclusions.isEmpty()) {
            sb.append(" specificExclusions {");
            boolean isFirst = true;
            for (String exclusion : this.exclusions) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(' ').append(exclusion);
            }
            sb.append(" },");
        }
        String refinementOrFilter = "";
        refinementOrFilter = this.refinementOrFilterVisible ? (this.refinementButton.getSelection() ? this.refinementText.getText() : this.filterWidget.getFilter()) : "";
        if (refinementOrFilter != null && !"".equals(refinementOrFilter)) {
            sb.append(" specificationFilter " + refinementOrFilter + ",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(" }");
        return sb.toString();
    }

    private void valueSelectedExclusionsTable() {
        String value = this.getSelectedValueExclusionsTable();
        if (value == null) {
            this.exclusionsTableEditButton.setEnabled(false);
            this.exclusionsTableDeleteButton.setEnabled(false);
        } else {
            this.exclusionsTableEditButton.setEnabled(true);
            this.exclusionsTableDeleteButton.setEnabled(true);
        }
    }

    private String getSelectedValueExclusionsTable() {
        Object element;
        String value = null;
        IStructuredSelection selection = (IStructuredSelection)this.exclusionsTableViewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof String) {
            value = (String)element;
        }
        return value;
    }

    private void addValueExclusionsTable() {
        ExclusionDialog dialog;
        Dn suffix;
        Dn chopBase = this.subtreeSpecification.getBase();
        if (this.useLocalName && this.subentryDn != null && !Dn.isNullOrEmpty((Dn)(suffix = this.subentryDn.getParent()))) {
            try {
                chopBase = chopBase.add(suffix);
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {}
        }
        if ((dialog = new ExclusionDialog(this.getShell(), this.connection, chopBase, "")).open() == 0 && !"".equals(dialog.getType()) && !"".equals(dialog.getDN())) {
            String newValue = String.valueOf(dialog.getType()) + ": \"" + dialog.getDN() + "\"";
            this.exclusions.add(newValue);
            this.exclusionsTableViewer.refresh();
            this.validate();
        }
    }

    private void editValueExclusionsTable() {
        String oldValue = this.getSelectedValueExclusionsTable();
        if (oldValue != null) {
            ExclusionDialog dialog;
            Dn suffix;
            Dn chopBase = this.subtreeSpecification.getBase();
            if (this.useLocalName && this.subentryDn != null && !Dn.isNullOrEmpty((Dn)(suffix = this.subentryDn.getParent()))) {
                try {
                    chopBase = chopBase.add(suffix);
                }
                catch (LdapInvalidDnException ldapInvalidDnException) {}
            }
            if ((dialog = new ExclusionDialog(this.getShell(), this.connection, chopBase, oldValue)).open() == 0 && !"".equals(dialog.getType()) && !"".equals(dialog.getDN())) {
                String newValue = String.valueOf(dialog.getType()) + ": \"" + dialog.getDN() + "\"";
                this.exclusions.remove(oldValue);
                this.exclusions.add(newValue);
                this.exclusionsTableViewer.refresh();
                this.validate();
            }
        }
    }

    private void deleteValueExclusionsTable() {
        String value = this.getSelectedValueExclusionsTable();
        if (value != null) {
            this.exclusions.remove(value);
            this.exclusionsTableViewer.refresh();
            this.validate();
        }
    }

    public String getSubtreeSpecificationValue() {
        return this.returnValue;
    }
}

