/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos;

import java.util.HashSet;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.shared.kerberos.KerberosUtils;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.codec.types.PrincipalNameType;

public class KerberosConfig {
    public static final String DEFAULT_PRINCIPAL = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    public static final String DEFAULT_REALM = "EXAMPLE.COM";
    public static final long DEFAULT_ALLOWABLE_CLOCKSKEW = 300000L;
    public static final boolean DEFAULT_EMPTY_ADDRESSES_ALLOWED = true;
    public static final boolean DEFAULT_PA_ENC_TIMESTAMP_REQUIRED = true;
    public static final int DEFAULT_TGS_MAXIMUM_TICKET_LIFETIME = 86400000;
    public static final int DEFAULT_TGS_MINIMUM_TICKET_LIFETIME = 240000;
    public static final int DEFAULT_TGS_MAXIMUM_RENEWABLE_LIFETIME = 604800000;
    public static final boolean DEFAULT_TGS_FORWARDABLE_ALLOWED = true;
    public static final boolean DEFAULT_TGS_PROXIABLE_ALLOWED = true;
    public static final boolean DEFAULT_TGS_POSTDATED_ALLOWED = true;
    public static final boolean DEFAULT_TGS_RENEWABLE_ALLOWED = true;
    public static final boolean DEFAULT_VERIFY_BODY_CHECKSUM = true;
    public static final String[] DEFAULT_ENCRYPTION_TYPES = new String[]{"aes128-cts-hmac-sha1-96", "des-cbc-md5", "des3-cbc-sha1-kd"};
    private String primaryRealm = "EXAMPLE.COM";
    private String servicePrincipal = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    private long allowableClockSkew = 300000L;
    private boolean isPaEncTimestampRequired = true;
    private long maximumTicketLifetime = 86400000L;
    private long minimumTicketLifetime = 240000L;
    private long maximumRenewableLifetime = 604800000L;
    private boolean isEmptyAddressesAllowed = true;
    private boolean isForwardableAllowed = true;
    private boolean isProxiableAllowed = true;
    private boolean isPostdatedAllowed = true;
    private boolean isRenewableAllowed = true;
    private boolean isBodyChecksumVerified = true;
    private Set<EncryptionType> encryptionTypes;
    private KerberosPrincipal srvPrincipal;
    private String searchBaseDn;

    public KerberosConfig() {
        this.setSearchBaseDn("ou=users,dc=example,dc=com");
        this.prepareEncryptionTypes();
    }

    public long getAllowableClockSkew() {
        return this.allowableClockSkew;
    }

    public boolean isEmptyAddressesAllowed() {
        return this.isEmptyAddressesAllowed;
    }

    public boolean isForwardableAllowed() {
        return this.isForwardableAllowed;
    }

    public boolean isPostdatedAllowed() {
        return this.isPostdatedAllowed;
    }

    public boolean isProxiableAllowed() {
        return this.isProxiableAllowed;
    }

    public boolean isRenewableAllowed() {
        return this.isRenewableAllowed;
    }

    public long getMaximumRenewableLifetime() {
        return this.maximumRenewableLifetime;
    }

    public long getMaximumTicketLifetime() {
        return this.maximumTicketLifetime;
    }

    public void setAllowableClockSkew(long allowableClockSkew) {
        this.allowableClockSkew = allowableClockSkew;
    }

    public void setEncryptionTypes(EncryptionType[] encryptionTypes) {
        if (encryptionTypes != null) {
            this.encryptionTypes.clear();
            for (EncryptionType encryptionType : encryptionTypes) {
                this.encryptionTypes.add(encryptionType);
            }
        }
        this.encryptionTypes = KerberosUtils.orderEtypesByStrength(this.encryptionTypes);
    }

    public void setEncryptionTypes(Set<EncryptionType> encryptionTypes) {
        this.encryptionTypes = KerberosUtils.orderEtypesByStrength(encryptionTypes);
    }

    public void setEmptyAddressesAllowed(boolean isEmptyAddressesAllowed) {
        this.isEmptyAddressesAllowed = isEmptyAddressesAllowed;
    }

    public void setForwardableAllowed(boolean isForwardableAllowed) {
        this.isForwardableAllowed = isForwardableAllowed;
    }

    public void setPaEncTimestampRequired(boolean isPaEncTimestampRequired) {
        this.isPaEncTimestampRequired = isPaEncTimestampRequired;
    }

    public void setPostdatedAllowed(boolean isPostdatedAllowed) {
        this.isPostdatedAllowed = isPostdatedAllowed;
    }

    public void setProxiableAllowed(boolean isProxiableAllowed) {
        this.isProxiableAllowed = isProxiableAllowed;
    }

    public void setRenewableAllowed(boolean isRenewableAllowed) {
        this.isRenewableAllowed = isRenewableAllowed;
    }

    public void setServicePrincipal(String kdcPrincipal) {
        this.servicePrincipal = kdcPrincipal;
    }

    public void setMaximumRenewableLifetime(long maximumRenewableLifetime) {
        this.maximumRenewableLifetime = maximumRenewableLifetime;
    }

    public void setMaximumTicketLifetime(long maximumTicketLifetime) {
        this.maximumTicketLifetime = maximumTicketLifetime;
    }

    public void setPrimaryRealm(String primaryRealm) {
        this.primaryRealm = primaryRealm;
    }

    public String getPrimaryRealm() {
        return this.primaryRealm;
    }

    public KerberosPrincipal getServicePrincipal() {
        if (this.srvPrincipal == null) {
            this.srvPrincipal = new KerberosPrincipal(this.servicePrincipal, PrincipalNameType.KRB_NT_SRV_INST.getValue());
        }
        return this.srvPrincipal;
    }

    public Set<EncryptionType> getEncryptionTypes() {
        return this.encryptionTypes;
    }

    public boolean isPaEncTimestampRequired() {
        return this.isPaEncTimestampRequired;
    }

    public boolean isBodyChecksumVerified() {
        return this.isBodyChecksumVerified;
    }

    public void setBodyChecksumVerified(boolean isBodyChecksumVerified) {
        this.isBodyChecksumVerified = isBodyChecksumVerified;
    }

    public String getSearchBaseDn() {
        return this.searchBaseDn;
    }

    public void setSearchBaseDn(String searchBaseDn) {
        this.searchBaseDn = searchBaseDn;
    }

    public long getMinimumTicketLifetime() {
        return this.minimumTicketLifetime;
    }

    public void setMinimumTicketLifetime(long minimumTicketLifetime) {
        this.minimumTicketLifetime = minimumTicketLifetime;
    }

    private void prepareEncryptionTypes() {
        String[] encryptionTypeStrings = DEFAULT_ENCRYPTION_TYPES;
        this.encryptionTypes = new HashSet<EncryptionType>();
        for (String enc : encryptionTypeStrings) {
            for (EncryptionType type : EncryptionType.getEncryptionTypes()) {
                if (!type.getName().equalsIgnoreCase(enc)) continue;
                this.encryptionTypes.add(type);
            }
        }
        this.encryptionTypes = KerberosUtils.orderEtypesByStrength(this.encryptionTypes);
    }
}

