/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.ldapResult;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.LdapResultImpl;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResultCode
extends GrammarAction<LdapMessageContainer<Message>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreResultCode.class);

    public StoreResultCode() {
        super("Store resultCode");
    }

    @Override
    public void action(LdapMessageContainer<Message> container) throws DecoderException {
        ResultResponse response;
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        ResultCodeEnum resultCode = ResultCodeEnum.SUCCESS;
        try {
            resultCode = ResultCodeEnum.getResultCode(IntegerDecoder.parse(value, 0, ResultCodeEnum.E_SYNC_REFRESH_REQUIRED.getResultCode()));
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_05108_INVALID_RESULT_CODE, Strings.dumpBytes(value.getData()), ide.getMessage()));
            throw new DecoderException(ide.getMessage(), ide);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05109_RESULT_CODE_IS, new Object[]{resultCode}));
        }
        LdapResult ldapResult = (response = (ResultResponse)container.getMessage()) == null ? new LdapResultImpl() : response.getLdapResult();
        container.setLdapResult(ldapResult);
        ldapResult.setResultCode(resultCode);
    }
}

