/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.parsers.DitStructureRuleDescriptionSchemaParser;
import org.apache.directory.api.util.Strings;

public final class DitStructureRuleDescriptionSyntaxChecker
extends SyntaxChecker {
    private transient DitStructureRuleDescriptionSchemaParser schemaParser = new DitStructureRuleDescriptionSchemaParser();
    public static final DitStructureRuleDescriptionSyntaxChecker INSTANCE = new DitStructureRuleDescriptionSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.17");

    private DitStructureRuleDescriptionSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        try {
            this.schemaParser.parseDITStructureRuleDescription(strValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
            }
            return true;
        }
        catch (ParseException pe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DitStructureRuleDescriptionSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.17");
        }

        @Override
        public DitStructureRuleDescriptionSyntaxChecker build() {
            return new DitStructureRuleDescriptionSyntaxChecker(this.oid);
        }
    }
}

