/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet.java;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourcePath;
import org.apache.torque.generator.variable.Variable;

public final class OutletUtils {
    private static Log log = LogFactory.getLog(OutletUtils.class);

    private OutletUtils() {
    }

    public static String getSourceElementAttribute(String elementName, String attributeName, ControllerState controllerState, Class<?> clazz) throws GeneratorException {
        SourceElement sourceElement = SourcePath.getElement((SourceElement)controllerState.getModel(), elementName, false);
        Object attribute = sourceElement.getAttribute(attributeName);
        if (attribute == null) {
            throw new GeneratorException("Source element attribute not set in " + clazz.getName() + "\nThe attribute " + attributeName + " of the source element " + elementName + " is not set.");
        }
        return attribute.toString();
    }

    public static String getOption(String optionName, ControllerState controllerState, Class<?> clazz) throws GeneratorException {
        Object optionValue = controllerState.getOption(optionName);
        if (optionValue == null) {
            throw new GeneratorException("Invalid configuration of " + clazz.getName() + "\nThe option " + optionName + " is not set.");
        }
        return optionValue.toString();
    }

    public static String getFromDifferentPlaces(String presetValue, String optionName, String variableName, String sourceElementName, String sourceElementAttribute, ControllerState controllerState, Class<?> clazz, String expectedFieldNames) throws GeneratorException {
        if (optionName != null && sourceElementName == null && presetValue == null && variableName == null) {
            return OutletUtils.getOption(optionName, controllerState, clazz);
        }
        if (sourceElementName != null && optionName == null && presetValue == null && variableName == null) {
            return OutletUtils.getSourceElementAttribute(sourceElementName, sourceElementAttribute, controllerState, clazz);
        }
        if (variableName != null && sourceElementName == null && optionName == null && presetValue == null) {
            Namespace namespace = controllerState.getOutlet().getName().getNamespace();
            QualifiedName variableQualifiedName = new QualifiedName(variableName, namespace);
            Variable variable = controllerState.getVariableStore().getInHierarchy(variableQualifiedName);
            if (variable == null) {
                log.info((Object)("clazz.getName() : Variable " + variableQualifiedName + " is not set, returning the empty String"));
                return "";
            }
            if (variable.getValue() == null) {
                log.info((Object)("clazz.getName() : Variable " + variableQualifiedName + " is set to null, returning the empty String"));
                return "";
            }
            return variable.getValue().toString();
        }
        if (presetValue != null && sourceElementName == null && optionName == null && variableName == null) {
            return presetValue;
        }
        throw new GeneratorException("Invalid configuration of " + clazz.getName() + "\nMake sure that one and only one of " + expectedFieldNames + " are set.");
    }
}

