/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public final class NetworkServerTestSetup
extends BaseTestSetup {
    private static final long DEFAULT_WAIT_TIME = 240000L;
    private static final long WAIT_TIME;
    private static final int SLEEP_TIME = 100;
    public static final String HOST_OPTION = "-h";
    private static long waitTime;
    private FileOutputStream serverOutput;
    private final boolean asCommand;
    private final boolean startServerAtSetup;
    private final boolean useSeparateProcess;
    private final boolean serverShouldComeUp;
    private final String[] systemProperties;
    private final String moduleOrClassPath;
    private final boolean useModules;
    private final boolean suppressServerDiagnostics;
    private String[] startupArgs;
    private SpawnedProcess spawnedServer;
    private NetworkServerControl networkServerController;

    public NetworkServerTestSetup(Test test, boolean bl) {
        super(test);
        this.asCommand = bl;
        this.systemProperties = null;
        this.startupArgs = null;
        this.useSeparateProcess = false;
        this.serverShouldComeUp = true;
        this.startServerAtSetup = true;
        this.moduleOrClassPath = null;
        this.useModules = false;
        this.suppressServerDiagnostics = false;
    }

    public NetworkServerTestSetup(Test test, boolean bl, boolean bl2) {
        super(test);
        this.asCommand = bl;
        this.systemProperties = null;
        this.startupArgs = null;
        this.useSeparateProcess = false;
        this.serverShouldComeUp = true;
        this.startServerAtSetup = bl2;
        this.moduleOrClassPath = null;
        this.useModules = false;
        this.suppressServerDiagnostics = false;
    }

    public NetworkServerTestSetup(Test test, String[] stringArray, String[] stringArray2, boolean bl) {
        this(test, stringArray, stringArray2, bl, null, JVMInfo.isModuleAware(), false);
    }

    public NetworkServerTestSetup(Test test, String[] stringArray, String[] stringArray2, boolean bl, String string, boolean bl2, boolean bl3) {
        super(test);
        this.asCommand = true;
        this.systemProperties = stringArray;
        this.startupArgs = stringArray2;
        this.useSeparateProcess = true;
        this.serverShouldComeUp = bl;
        this.startServerAtSetup = true;
        this.moduleOrClassPath = string;
        this.useModules = bl2;
        this.suppressServerDiagnostics = bl3;
    }

    protected void setUp() throws Exception {
        BaseTestCase.println("Starting network server:");
        this.networkServerController = NetworkServerTestSetup.getNetworkServerControl();
        if (this.startServerAtSetup) {
            NetworkServerTestSetup.waitForAvailablePort();
            if (this.useSeparateProcess) {
                this.spawnedServer = this.startSeparateProcess();
            } else if (this.asCommand) {
                this.startWithCommand();
            } else {
                this.startWithAPI();
            }
            if (this.serverShouldComeUp && !NetworkServerTestSetup.pingForServerStart(this.networkServerController)) {
                String string = NetworkServerTestSetup.getTimeoutErrorMsg("network server to start");
                if (this.spawnedServer != null) {
                    this.spawnedServer.complete(2000L);
                    string = this.spawnedServer.getFailMessage(string);
                    this.spawnedServer = null;
                }
                JVMInfo.javaDump();
                NetworkServerTestSetup.fail((String)(string + Utilities.NL + ExceptionUtil.dumpThreads()));
            }
        }
    }

    public static void waitForAvailablePort() throws InterruptedException, UnknownHostException {
        NetworkServerTestSetup.waitForAvailablePort(TestConfiguration.getCurrent().getPort());
    }

    public static void waitForAvailablePort(int n) throws InterruptedException, UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(TestConfiguration.getCurrent().getHostName());
        long l = System.currentTimeMillis() + NetworkServerTestSetup.getWaitTime();
        BaseTestCase.println("probing port for availability: " + inetAddress + ":" + n);
        while (true) {
            try {
                NetworkServerTestSetup.probeServerPort(n, inetAddress);
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() < l) {
                    Thread.sleep(100L);
                    continue;
                }
                BaseTestCase.fail(NetworkServerTestSetup.getTimeoutErrorMsg("server port to become available", n), iOException);
                continue;
            }
            break;
        }
    }

    private static void probeServerPort(final int n, final InetAddress inetAddress) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    new ServerSocket(n, 0, inetAddress).close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private void startWithAPI() throws Exception {
        BaseTestCase.println("Starting network server with NetworkServerControl api:");
        this.serverOutput = AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() {
                File file = new File("logs");
                file.mkdir();
                File file2 = new File(file, "serverConsoleOutput.log");
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file2.getPath(), true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                return fileOutputStream;
            }
        });
        this.networkServerController.start(new PrintWriter(this.serverOutput));
    }

    private void startWithCommand() throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String[] stringArray = NetworkServerTestSetup.getDefaultStartupArgs(false);
                BaseTestCase.println("Starting network server with this command: " + Arrays.asList(stringArray));
                NetworkServerControl.main((String[])stringArray);
            }
        }, "NetworkServerTestSetup command").start();
    }

    private SpawnedProcess startSeparateProcess() throws Exception {
        int n;
        BaseTestCase.println("Starting network server as a separate process:");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        if (!TestConfiguration.loadingFromJars() || BaseTestCase.runsWithEmma() || BaseTestCase.runsWithJaCoCo()) {
            int n2;
            n = 1;
            for (n2 = 0; n2 < this.systemProperties.length; ++n2) {
                if (!this.systemProperties[n2].startsWith("java.security.")) continue;
                n = 0;
                break;
            }
            for (n2 = 0; n2 < this.startupArgs.length; ++n2) {
                if (!this.startupArgs[n2].equals("-noSecurityManager")) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                String[] stringArray = new String[this.startupArgs.length + 1];
                System.arraycopy(this.startupArgs, 0, stringArray, 0, this.startupArgs.length);
                stringArray[stringArray.length - 1] = "-noSecurityManager";
                this.startupArgs = stringArray;
            }
        }
        n = this.systemProperties.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add("-D" + this.systemProperties[i]);
        }
        String string = NetworkServerControl.class.getName();
        if (this.useModules) {
            arrayList.add("-m");
            arrayList.add("org.apache.derby.server/" + string);
        } else {
            arrayList.add(string);
        }
        n = this.startupArgs.length;
        for (int i = 0; i < n; ++i) {
            if (!HOST_OPTION.equals(this.startupArgs[i])) continue;
            bl = true;
        }
        arrayList.addAll(Arrays.asList(NetworkServerTestSetup.getDefaultStartupArgs(bl)));
        arrayList.addAll(Arrays.asList(this.startupArgs));
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        Process process = BaseTestCase.execJavaCmd(null, this.moduleOrClassPath, stringArray, null, true, this.useModules);
        return new SpawnedProcess(process, "SpawnedNetworkServer");
    }

    public SpawnedProcess getServerProcess() {
        return this.spawnedServer;
    }

    protected void tearDown() throws Exception {
        if (this.networkServerController != null) {
            Throwable throwable;
            block13: {
                boolean bl = false;
                try {
                    this.networkServerController.ping();
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throwable = null;
                if (bl) {
                    try {
                        this.networkServerController.shutdown();
                    }
                    catch (Throwable throwable2) {
                        String string = throwable2.getMessage();
                        if (string != null && string.contains("DRDA_InvalidReplyHead")) break block13;
                        throwable = throwable2;
                    }
                }
            }
            if (this.serverOutput != null) {
                this.serverOutput.close();
            }
            this.networkServerController = null;
            this.serverOutput = null;
            if (this.spawnedServer != null) {
                if (this.suppressServerDiagnostics) {
                    this.spawnedServer.suppressOutputOnComplete();
                }
                this.spawnedServer.complete(NetworkServerTestSetup.getWaitTime());
                this.spawnedServer = null;
            }
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    if (!(throwable instanceof SQLException)) {
                        throw (Exception)throwable;
                    }
                } else {
                    throw (Error)throwable;
                }
            }
        }
    }

    public static String[] getDefaultStartupArgs(boolean bl) {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("start");
        if (!bl) {
            arrayList.add(HOST_OPTION);
            arrayList.add(testConfiguration.getHostName());
        }
        arrayList.add("-p");
        arrayList.add(Integer.toString(testConfiguration.getPort()));
        if (testConfiguration.getSsl() != null) {
            arrayList.add("-ssl");
            arrayList.add(testConfiguration.getSsl());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static NetworkServerControl getNetworkServerControl() throws Exception {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        InetAddress inetAddress = InetAddress.getByName(testConfiguration.getHostName());
        int n = testConfiguration.getPort();
        String string = testConfiguration.getUserName();
        String string2 = testConfiguration.getUserPassword();
        if (testConfiguration.getSsl() == null) {
            return new NetworkServerControl(inetAddress, n, string, string2);
        }
        String string3 = BaseTestCase.getSystemProperty("derby.drda.sslMode");
        BaseTestCase.setSystemProperty("derby.drda.sslMode", testConfiguration.getSsl());
        NetworkServerControl networkServerControl = new NetworkServerControl(inetAddress, n, string, string2);
        if (string3 == null) {
            BaseTestCase.removeSystemProperty("derby.drda.sslMode");
        } else {
            BaseTestCase.setSystemProperty("derby.drda.sslMode", string3);
        }
        return networkServerControl;
    }

    public static NetworkServerControl getNetworkServerControl(int n) throws Exception {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        InetAddress inetAddress = InetAddress.getByName(testConfiguration.getHostName());
        String string = testConfiguration.getUserName();
        String string2 = testConfiguration.getUserPassword();
        return new NetworkServerControl(inetAddress, n, string, string2);
    }

    public static NetworkServerControl getNetworkServerControlDefault() throws Exception {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        String string = testConfiguration.getUserName();
        String string2 = testConfiguration.getUserPassword();
        return new NetworkServerControl(string, string2);
    }

    public static void waitForServerStart(NetworkServerControl networkServerControl) throws InterruptedException {
        if (!NetworkServerTestSetup.pingForServerStart(networkServerControl)) {
            NetworkServerTestSetup.fail((String)NetworkServerTestSetup.getTimeoutErrorMsg("network server to start"));
        }
    }

    public static void setWaitTime(long l) {
        waitTime = l;
    }

    public static void setDefaultWaitTime() {
        waitTime = WAIT_TIME;
    }

    public static boolean pingForServerUp(NetworkServerControl networkServerControl, Process process, boolean bl) throws InterruptedException {
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        while (true) {
            try {
                networkServerControl.ping();
                long l2 = System.currentTimeMillis() - l;
                if (bl) {
                    if (l2 > 60000L) {
                        BaseTestCase.alarm("Very slow server startup: " + l2 + " ms");
                    }
                    return true;
                }
                if (l2 > waitTime) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                if (!NetworkServerTestSetup.vetPing(throwable)) {
                    if (!bl2 && throwable.getMessage().startsWith("DRDA_InvalidReplyTooShort.S:")) {
                        bl2 = true;
                        Thread.sleep(100L);
                        continue;
                    }
                    throwable.printStackTrace(System.out);
                    return false;
                }
                if (bl) {
                    if (System.currentTimeMillis() - l > waitTime) {
                        return false;
                    }
                }
                return false;
            }
            if (process != null) {
                try {
                    int n = process.exitValue();
                    return false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.out);
                    return false;
                }
            }
            Thread.sleep(100L);
        }
    }

    private static boolean vetPing(Throwable throwable) {
        if (!throwable.getClass().getName().equals("java.lang.Exception")) {
            return false;
        }
        return throwable.getMessage().startsWith("DRDA_NoIO.S:");
    }

    private static boolean isDRDAerror(Throwable throwable) {
        if (!throwable.getClass().getName().equals("java.lang.Exception")) {
            return false;
        }
        return throwable.getMessage().startsWith("DRDA");
    }

    public static boolean pingForServerStart(NetworkServerControl networkServerControl) throws InterruptedException {
        return NetworkServerTestSetup.pingForServerUp(networkServerControl, null, true);
    }

    public static long getWaitTime() {
        long l = 240000L;
        String string = BaseTestCase.getSystemProperty("derby.tests.networkServerStartTimeout");
        if (string != null && string.length() != 0) {
            try {
                l = Long.parseLong(string) * 1000L;
            }
            catch (Exception exception) {
                BaseTestCase.fail("trouble setting WAIT_TIME from passed in property derby.tests.networkServerStartTimeout", exception);
            }
        }
        return l;
    }

    private static String getTimeoutErrorMsg(String string, int n) {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        String string2 = testConfiguration.getHostName();
        return "Timed out waiting for " + string + " (" + string2 + ":" + n + ")";
    }

    private static String getTimeoutErrorMsg(String string) {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        int n = testConfiguration.getPort();
        return NetworkServerTestSetup.getTimeoutErrorMsg(string, n);
    }

    static {
        waitTime = WAIT_TIME = NetworkServerTestSetup.getWaitTime();
    }
}

