/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class KeepDisposableStatsPropertyTest
extends BaseJDBCTestCase {
    public KeepDisposableStatsPropertyTest(String string) {
        super(string);
    }

    public void testPropertyFalse() throws SQLException {
        this.assertOnSCUI(false);
    }

    public void testPropertyTrue() throws SQLException {
        this.assertOnSCUI(true);
    }

    public void testPropertyDefault() throws SQLException {
        this.assertOnSCUI(false);
    }

    private void assertOnSCUI(boolean bl) throws SQLException {
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.openDefaultConnection(), 20000L);
        String string = "STAT_SCUI";
        this.dropTable(string);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table " + string + " (id int not null, val int)");
        indexStatsUtil.assertNoStatsTable(string);
        PreparedStatement preparedStatement = this.prepareStatement("insert into " + string + " values (?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 20; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
        statement.executeUpdate("alter table " + string + " add constraint PK_" + string + " primary key(id)");
        indexStatsUtil.assertTableStats(string, bl ? 1 : 0);
        statement.executeUpdate("create unique index UNIQ_IDX_" + string + " ON " + string + "(val)");
        indexStatsUtil.assertTableStats(string, bl ? 2 : 0);
        PreparedStatement preparedStatement2 = this.prepareStatement("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', ?, ?)");
        preparedStatement2.setString(1, string);
        preparedStatement2.setNull(2, 12);
        preparedStatement2.execute();
        indexStatsUtil.assertTableStats(string, bl ? 2 : 0);
        preparedStatement2.setString(2, "UNIQ_IDX_" + string);
        preparedStatement2.execute();
        indexStatsUtil.assertTableStats(string, bl ? 2 : 0);
        statement.execute("call SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP', '" + string + "', null)");
        indexStatsUtil.assertNoStatsTable(string);
        preparedStatement2.execute();
        indexStatsUtil.assertTableStats(string, bl ? 1 : 0);
        preparedStatement2.setNull(2, 12);
        preparedStatement2.execute();
        indexStatsUtil.assertTableStats(string, bl ? 2 : 0);
        IndexStatsUtil.IdxStats[] idxStatsArray = indexStatsUtil.getStatsTable(string);
        this.setAutoCommit(false);
        for (int i = 20; i < 2000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
        this.prepareStatement("select * from " + string + " where id = ?");
        IndexStatsUtil.IdxStats[] idxStatsArray2 = indexStatsUtil.getNewStatsTable(string, idxStatsArray);
        KeepDisposableStatsPropertyTest.assertEquals((int)idxStatsArray.length, (int)idxStatsArray2.length);
        for (int i = 0; i < idxStatsArray.length; ++i) {
            KeepDisposableStatsPropertyTest.assertEquals((boolean)bl, (boolean)idxStatsArray2[i].after(idxStatsArray[i]));
        }
        this.dropTable(string);
        indexStatsUtil.release();
    }

    public static Test suite() {
        String string = "derby.storage.indexStats.debug.keepDisposableStats";
        BaseTestSuite baseTestSuite = new BaseTestSuite("KeepDisposableStatsPropertyTestSuite");
        baseTestSuite.addTest((Test)new KeepDisposableStatsPropertyTest("testPropertyDefault"));
        Properties properties = new Properties();
        properties.setProperty(string, "true");
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("Do KeepDisposableStats");
        baseTestSuite2.addTest((Test)new KeepDisposableStatsPropertyTest("testPropertyTrue"));
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup((Test)baseTestSuite2, properties, true));
        Properties properties2 = new Properties();
        properties2.setProperty(string, "false");
        BaseTestSuite baseTestSuite3 = new BaseTestSuite("Don't KeepDisposableStats");
        baseTestSuite3.addTest((Test)new KeepDisposableStatsPropertyTest("testPropertyFalse"));
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup((Test)baseTestSuite3, properties2, true));
        return baseTestSuite;
    }
}

