/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;
import org.apache.derbyTesting.junit.Utilities;

public class AutomaticIndexStatisticsTest
extends BaseJDBCTestCase {
    protected static final String MASTERDB = "masterDb";
    private static final String BIG_TABLE = "BIG_TABLE";
    private static final long DEFAULT_TIMEOUT = 20000L;
    private static final String[] TYPES = new String[]{"TABLE", "VIEW"};
    private static boolean dbCreated;
    private static IndexStatsUtil stats;

    public AutomaticIndexStatisticsTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = new BaseTestSuite(AutomaticIndexStatisticsTest.class);
        object = new CleanDatabaseTestSetup((Test)object);
        object = TestConfiguration.additionalDatabaseDecorator((Test)object, MASTERDB);
        return new TimeZoneTestSetup((Test)object, "GMT");
    }

    public void setUp() throws SQLException {
        if (stats != null) {
            stats.release();
        }
        stats = new IndexStatsUtil(this.openDefaultConnection(), 20000L);
    }

    @Override
    public void tearDown() throws Exception {
        if (stats != null) {
            stats.release();
        }
        stats = null;
        super.tearDown();
    }

    public void testStatsCreatedOnGrowthThenDeleteDb() throws SQLException {
        String string = "singleUse/newCleanDb";
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        Connection connection = dataSource.getConnection();
        String string2 = "TEST_GROWTH_EMPTY";
        this.createAndInsertSimple(connection, string2, 300);
        PreparedStatement preparedStatement = connection.prepareStatement("select * from " + string2 + " where id = ?");
        preparedStatement.close();
        IndexStatsUtil.IdxStats[] idxStatsArray = new IndexStatsUtil(dataSource.getConnection(), 20000L).getStatsTable(string2, 1);
        AutomaticIndexStatisticsTest.assertEquals((int)1, (int)idxStatsArray.length);
        AutomaticIndexStatisticsTest.assertTrue((idxStatsArray[0].rows == 300L ? 1 : 0) != 0);
        JDBCDataSource.shutdownDatabase(dataSource);
        AutomaticIndexStatisticsTest.assertDirectoryDeleted(this.constructDbPath(string));
    }

    public void testStatsUpdatedOnGrowth() throws SQLException {
        String string = "TEST_GROWTH";
        this.createAndInsertSimple(string, 10000);
        this.prepareStatement("select * from " + string + " where id = ?");
        IndexStatsUtil.IdxStats[] idxStatsArray = stats.getStatsTable(string, 1);
        AutomaticIndexStatisticsTest.assertEquals((int)1, (int)idxStatsArray.length);
        this.setAutoCommit(false);
        this.insertSimple(string, 50000, 10000);
        this.forceRowCountEstimateUpdate(string);
        this.prepareStatement("select * from " + string + " where 1=1");
        IndexStatsUtil.IdxStats[] idxStatsArray2 = this.getFilteredTableStats(string, 1, idxStatsArray);
        AutomaticIndexStatisticsTest.assertEquals((int)1, (int)idxStatsArray2.length);
        AutomaticIndexStatisticsTest.assertFalse((boolean)idxStatsArray[0].equals(idxStatsArray2[0]));
        AutomaticIndexStatisticsTest.assertFalse((boolean)idxStatsArray[0].after(idxStatsArray2[0]));
        this.insertSimple(string, 1000, 60000);
        this.forceRowCountEstimateUpdate(string);
        this.prepareStatement("select * from " + string + " where 2=2");
        Utilities.sleep(1500L);
        IndexStatsUtil.IdxStats[] idxStatsArray3 = stats.getStatsTable(string, 1);
        AutomaticIndexStatisticsTest.assertTrue((boolean)idxStatsArray2[0].equals(idxStatsArray3[0]));
        AutomaticIndexStatisticsTest.assertFalse((boolean)idxStatsArray3[0].after(idxStatsArray2[0]));
    }

    public void testShutdownWhileScanningThenDelete() throws IOException, SQLException {
        String string = "singleUse/copyShutdown";
        this.copyDb(string);
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", string);
        Connection connection = dataSource.getConnection();
        String string2 = BIG_TABLE;
        PreparedStatement preparedStatement = connection.prepareStatement("select * from " + string2 + " where id = ?");
        preparedStatement.close();
        Utilities.sleep(150L);
        JDBCDataSource.shutdownDatabase(dataSource);
        AutomaticIndexStatisticsTest.assertDirectoryDeleted(this.constructDbPath(string));
    }

    public void testDropWhileScanningThenDelete() throws IOException, SQLException {
        String string = BIG_TABLE;
        String string2 = "SECONDARY_TABLE";
        String string3 = "singleUse/copyDrop";
        this.copyDb(string3);
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", string3);
        Connection connection = dataSource.getConnection();
        this.createAndInsertSimple(connection, string2, 20000);
        PreparedStatement preparedStatement = connection.prepareStatement("select * from " + string + " where id = ?");
        preparedStatement.close();
        Utilities.sleep(150L);
        AutomaticIndexStatisticsTest.println("dropping table...");
        Statement statement = connection.createStatement();
        statement.executeUpdate("drop table " + string);
        statement.close();
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(dataSource.getConnection(), 20000L);
        indexStatsUtil.assertNoStatsTable(string2);
        connection.prepareStatement("select * from " + string2 + " where id = ?");
        indexStatsUtil.assertTableStats(string2, 1);
        indexStatsUtil.release();
        JDBCDataSource.shutdownDatabase(dataSource);
        AutomaticIndexStatisticsTest.assertDirectoryDeleted(this.constructDbPath(string3));
    }

    public void testCompressWhileScanning() throws IOException, SQLException {
        String string = BIG_TABLE;
        String string2 = "SECONDARY_TABLE";
        String string3 = "singleUse/copyCompress";
        this.copyDb(string3);
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", string3);
        Connection connection = dataSource.getConnection();
        this.createAndInsertSimple(connection, string2, 20000);
        PreparedStatement preparedStatement = connection.prepareStatement("select * from " + string + " where id = ?");
        preparedStatement.close();
        Utilities.sleep(150L);
        AutomaticIndexStatisticsTest.println("compressing table...");
        Statement statement = connection.createStatement();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', '" + string + "', 0)");
        statement.close();
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(dataSource.getConnection(), 20000L);
        indexStatsUtil.assertTableStats(string, 1);
        indexStatsUtil.assertNoStatsTable(string2);
        connection.prepareStatement("select * from " + string2 + " where id = ?");
        indexStatsUtil.assertTableStats(string2, 1);
        indexStatsUtil.release();
        JDBCDataSource.shutdownDatabase(dataSource);
        AutomaticIndexStatisticsTest.assertDirectoryDeleted(this.constructDbPath(string3));
    }

    public void testStatisticsCorrectness() throws SQLException {
        int n;
        String string = "STAT_CORR";
        this.dropTable(string);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table " + string + " (id1 int, id2 int, id3 int, val int, primary key (id1, id2, id3))");
        stats.assertNoStatsTable(string);
        PreparedStatement preparedStatement = this.prepareStatement("insert into " + string + " values (?,?,?,?)");
        this.setAutoCommit(false);
        for (int i = 1; i <= 100; ++i) {
            preparedStatement.setInt(1, i);
            for (int j = 1; j <= 50; ++j) {
                preparedStatement.setInt(2, j);
                for (n = 1; n <= 10; ++n) {
                    preparedStatement.setInt(3, n);
                    preparedStatement.setInt(4, i * j * n % 750);
                    preparedStatement.executeUpdate();
                }
            }
        }
        this.commit();
        this.setAutoCommit(true);
        this.forceRowCountEstimateUpdate(string);
        JDBC.assertDrainResults(this.prepareStatement("select * from " + string + " where id1 = 10").executeQuery());
        IndexStatsUtil.IdxStats[] idxStatsArray = stats.getStatsTable(string, 3);
        AutomaticIndexStatisticsTest.assertEquals((int)3, (int)idxStatsArray.length);
        Timestamp timestamp = new Timestamp(new Date().getTime());
        block13: for (n = 0; n < idxStatsArray.length; ++n) {
            IndexStatsUtil.IdxStats idxStats = idxStatsArray[n];
            AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)idxStats.rows);
            AutomaticIndexStatisticsTest.assertFalse((String)("expected stat created in past:now = " + timestamp + ";s.created = " + idxStats.created), (idxStats.created.compareTo(timestamp) > 0 ? 1 : 0) != 0);
            switch (idxStats.lcols) {
                case 1: {
                    AutomaticIndexStatisticsTest.assertEquals((long)100L, (long)idxStats.card);
                    continue block13;
                }
                case 2: {
                    AutomaticIndexStatisticsTest.assertEquals((long)5000L, (long)idxStats.card);
                    continue block13;
                }
                case 3: {
                    AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)idxStats.card);
                    continue block13;
                }
                default: {
                    AutomaticIndexStatisticsTest.fail((String)("unexpected number of leading columns: " + idxStats.lcols));
                }
            }
        }
        statement.executeUpdate("create index IDXREV on " + string + "(id3, id2, id1)");
        idxStatsArray = stats.getStatsIndex("IDXREV", 3);
        AutomaticIndexStatisticsTest.assertEquals((int)3, (int)idxStatsArray.length);
        Timestamp timestamp2 = timestamp;
        timestamp = new Timestamp(new Date().getTime());
        block14: for (int i = 0; i < idxStatsArray.length; ++i) {
            IndexStatsUtil.IdxStats idxStats = idxStatsArray[i];
            AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)idxStats.rows);
            AutomaticIndexStatisticsTest.assertTrue((String)("current stats created " + idxStats.created + ", previous stats created " + timestamp2), (boolean)idxStats.created.after(timestamp2));
            AutomaticIndexStatisticsTest.assertFalse((String)("expected stat created in past:now = " + timestamp + ";s.created = " + idxStats.created), (idxStats.created.compareTo(timestamp) > 0 ? 1 : 0) != 0);
            switch (idxStats.lcols) {
                case 1: {
                    AutomaticIndexStatisticsTest.assertEquals((long)10L, (long)idxStats.card);
                    continue block14;
                }
                case 2: {
                    AutomaticIndexStatisticsTest.assertEquals((long)500L, (long)idxStats.card);
                    continue block14;
                }
                case 3: {
                    AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)idxStats.card);
                    continue block14;
                }
                default: {
                    AutomaticIndexStatisticsTest.fail((String)("unexpected number of leading columns: " + idxStats.lcols));
                }
            }
        }
        statement.executeUpdate("create index IDXVAL on " + string + "(val)");
        ResultSet resultSet = statement.executeQuery("select val from " + string + " order by val");
        int n2 = 0;
        int n3 = -1;
        while (resultSet.next()) {
            int n4 = resultSet.getInt(1);
            if (n4 == n3) continue;
            ++n2;
            n3 = n4;
        }
        resultSet.close();
        IndexStatsUtil.IdxStats[] idxStatsArray2 = stats.getStatsIndex("IDXVAL", 1);
        AutomaticIndexStatisticsTest.assertEquals((int)1, (int)idxStatsArray2.length);
        AutomaticIndexStatisticsTest.assertEquals((long)n2, (long)idxStatsArray2[0].card);
        AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)idxStatsArray2[0].rows);
    }

    public void testSelectFromSimpleView() throws SQLException {
        String string = "VIEW_BASE_TABLE";
        String string2 = "MY_VIEW";
        AutomaticIndexStatisticsTest.dropIfExists(this.getConnection(), string2);
        AutomaticIndexStatisticsTest.dropIfExists(this.getConnection(), string);
        Statement statement = this.createStatement();
        statement.execute("create table " + string + " (id int primary key, col1 int, col2 int)");
        statement.execute("create index COL2_IDX on " + string + "(col2)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into " + string + " values (?,?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 30000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i % 15);
            preparedStatement.setInt(3, i % 25);
            preparedStatement.executeUpdate();
            if (i % 5000 != 0) continue;
            this.commit();
        }
        this.commit();
        this.setAutoCommit(true);
        preparedStatement.close();
        statement.execute("create view " + string2 + "(vcol_1, vcol2) AS select id, col2 from " + string);
        stats.assertNoStatsTable(string);
        this.prepareStatement("select * from " + string2 + " where vcol2 = 7");
        stats.assertNoStatsTable(string);
        this.prepareStatement("select * from " + string + " where col2 = 7");
        stats.assertTableStats(string, 1);
    }

    public void testNoUpdateTriggeredBySingleColumnUniqueIndex() throws SQLException {
        String string = "STAT_SCUI";
        this.dropTable(string);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table " + string + " (id int primary key, val int unique not null)");
        stats.assertNoStatsTable(string);
        PreparedStatement preparedStatement = this.prepareStatement("insert into " + string + " values (?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 2000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        PreparedStatement preparedStatement2 = this.prepareStatement("select id from " + string + " where id = ?");
        preparedStatement2.setInt(1, 98);
        JDBC.assertSingleValueResultSet(preparedStatement2.executeQuery(), "98");
        PreparedStatement preparedStatement3 = this.prepareStatement("select val from " + string + " where val = ?");
        preparedStatement3.setInt(1, 1573);
        JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), "1573");
        Utilities.sleep(100L);
        stats.assertNoStatsTable(string);
        for (int i = 2000; i < 4000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        this.forceRowCountEstimateUpdate(string);
        preparedStatement2 = this.prepareStatement("select id from " + string + " where id = ?");
        preparedStatement2.setInt(1, 117);
        JDBC.assertSingleValueResultSet(preparedStatement2.executeQuery(), "117");
        preparedStatement3 = this.prepareStatement("select val from " + string + " where val = ?");
        preparedStatement3.setInt(1, 1);
        JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), "1");
        Utilities.sleep(100L);
        stats.assertNoStatsTable(string);
        this.dropTable(string);
    }

    private void copyDb(String string) throws IOException, SQLException {
        if (!dbCreated) {
            this.createMasterDb();
        }
        File file = this.constructDbPath(TestConfiguration.getCurrent().getPhysicalDatabaseName(MASTERDB));
        final File file2 = this.constructDbPath(string);
        if (!PrivilegedFileOpsForTests.exists(file2.getParentFile())) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Assert.assertTrue((boolean)file2.getParentFile().mkdirs());
                    return null;
                }
            });
        }
        PrivilegedFileOpsForTests.copy(file, file2);
    }

    private void createMasterDb() throws SQLException {
        long l = System.currentTimeMillis();
        String string = BIG_TABLE;
        int n = 1000000;
        DataSource dataSource = JDBCDataSource.getDataSourceLogical(MASTERDB);
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        Connection connection = dataSource.getConnection();
        AutomaticIndexStatisticsTest.dropIfExists(connection, string);
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table " + string + "(id int primary key)");
        statement.close();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + string + " values ?");
        for (int i = 0; i < n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.addBatch();
            if (i % 5000 != 0) continue;
            preparedStatement.executeBatch();
            connection.commit();
        }
        preparedStatement.executeBatch();
        connection.commit();
        connection.close();
        AutomaticIndexStatisticsTest.println("created master db with " + n + " rows in " + (System.currentTimeMillis() - l) / 1000L + " seconds");
        JDBCDataSource.shutdownDatabase(JDBCDataSource.getDataSourceLogical(MASTERDB));
        dbCreated = true;
    }

    private void forceRowCountEstimateUpdate(String string) throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertDrainResults(statement.executeQuery("select count(*) from " + string));
        statement.execute("call SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
        statement.close();
    }

    private File constructDbPath(String string) {
        File file = new File(AutomaticIndexStatisticsTest.getSystemProperty("derby.system.home"));
        return new File(file, string);
    }

    private void createAndInsertSimple(String string, int n) throws SQLException {
        this.createAndInsertSimple(null, string, n);
    }

    private void createAndInsertSimple(Connection connection, String string, int n) throws SQLException {
        IndexStatsUtil indexStatsUtil;
        Statement statement;
        if (connection == null) {
            connection = this.getConnection();
            statement = this.createStatement();
            indexStatsUtil = stats;
        } else {
            statement = connection.createStatement();
            indexStatsUtil = new IndexStatsUtil(connection);
        }
        AutomaticIndexStatisticsTest.dropIfExists(connection, string);
        statement.executeUpdate("create table " + string + "(id int primary key, val int)");
        statement.executeUpdate("create index NON_UNIQUE_INDEX_" + string + " on " + string + "(val)");
        indexStatsUtil.assertNoStatsTable(string);
        long l = System.currentTimeMillis();
        AutomaticIndexStatisticsTest.println("created " + string + ", inserting " + n + " rows");
        this.insertSimple(connection, string, n, 0);
        AutomaticIndexStatisticsTest.println("completed in " + (System.currentTimeMillis() - l) + " ms");
        indexStatsUtil.assertNoStatsTable(string);
    }

    private void insertSimple(String string, int n, int n2) throws SQLException {
        this.insertSimple(this.getConnection(), string, n, n2);
    }

    private void insertSimple(Connection connection, String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + string + " values (?,?)");
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        for (int i = n2; i < n2 + n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i % 20);
            preparedStatement.addBatch();
            if (i % 5000 != 0) continue;
            preparedStatement.executeBatch();
            connection.commit();
        }
        preparedStatement.executeBatch();
        connection.commit();
        connection.setAutoCommit(bl);
    }

    private IndexStatsUtil.IdxStats[] getFilteredTableStats(String string, int n, IndexStatsUtil.IdxStats[] idxStatsArray) throws SQLException {
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 20000L) {
            IndexStatsUtil.IdxStats[] idxStatsArray2 = stats.getStatsTable(string, n);
            boolean bl = true;
            if (idxStatsArray != null) {
                block1: for (int i = 0; i < idxStatsArray2.length; ++i) {
                    for (int j = 0; j < idxStatsArray.length; ++j) {
                        if (!idxStatsArray2[i].equals(idxStatsArray[j])) continue;
                        bl = false;
                        continue block1;
                    }
                }
            }
            if (bl) {
                return idxStatsArray2;
            }
            Utilities.sleep(250L);
        }
        AutomaticIndexStatisticsTest.fail((String)("getting stats for table " + string + " timed out (#expected=" + n + ", #oldStats=" + (idxStatsArray == null ? 0 : idxStatsArray.length) + ")"));
        return null;
    }

    private static void dropIfExists(Connection connection, String string) throws SQLException {
        ResultSet resultSet = connection.getMetaData().getTables(null, null, string, TYPES);
        while (resultSet.next()) {
            String string2 = resultSet.getString(4);
            if (string2.equals("TABLE")) {
                AutomaticIndexStatisticsTest.dropTable(connection, string);
                continue;
            }
            if (string2.equals("VIEW")) {
                connection.createStatement().executeUpdate("drop view " + string);
                continue;
            }
            AutomaticIndexStatisticsTest.fail((String)("entity " + string + " of unsupported type: " + string2));
        }
        resultSet.close();
    }
}

