/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_Encrypted_1
extends ReplicationRun {
    public ReplicationRun_Local_Encrypted_1(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        dataEncryption = "bootPassword=dilldall";
    }

    @Override
    protected void tearDown() throws Exception {
        dataEncryption = null;
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_Encrypted_1 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_Encrypted_1.class);
        return SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
    }

    public void testReplication_Encrypted_1_stdLoad() throws Exception {
        this.makeReadyForReplication();
        replicationTest = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun";
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun_Verify";
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    public void testReplication_Encrypted_1_miniLoad_negative() throws Exception {
        this.makeReadyForReplication();
        String string = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        int n = 10000;
        this._testInsertUpdateDeleteOnMaster(masterServerHost, masterServerPort, string, n);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        String string2 = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
        this._verifyDatabase(slaveServerHost, slaveServerPort, string2, n);
        String string3 = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        this._verifyDatabase(masterServerHost, masterServerPort, string3, n);
        dataEncryption = null;
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, string2), null);
        dataEncryption = "bootPassword=;";
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, string2), null);
        dataEncryption = "bootPassword=dill2dall";
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, string2), null);
        this.shutdownDb(jvmVersion, slaveServerHost, slaveServerPort, slaveDatabasePath + FS + slaveDbSubPath, replicatedDb, testClientHost);
        dataEncryption = null;
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, string2), "XJ040");
        dataEncryption = "bootPassword=;";
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, string2), "XJ040");
        dataEncryption = "bootPassword=dill2dall";
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, string2), "XJ040");
        dataEncryption = "bootPassword=dilldall";
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    SQLException _connectToSlave(String string, int n, String string2) throws Exception {
        ClientDataSourceInterface clientDataSourceInterface;
        this.util.DEBUG("_connectToSlave");
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientDataSourceInterface.setDatabaseName(string2);
        clientDataSourceInterface.setServerName(string);
        clientDataSourceInterface.setPortNumber(n);
        clientDataSourceInterface.setConnectionAttributes(this.useEncryption(false));
        try {
            Connection connection = clientDataSourceInterface.getConnection();
            connection.close();
            return null;
        }
        catch (SQLException sQLException) {
            return sQLException;
        }
    }
}

